/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.scan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.querykit.BaseLeafFrameProcessorFactory;
import org.apache.druid.msq.querykit.LazyResourceHolder;
import org.apache.druid.msq.querykit.scan.ScanQueryFrameProcessor;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinableFactoryWrapper;

@JsonTypeName(value="scan")
public class ScanQueryFrameProcessorFactory
extends BaseLeafFrameProcessorFactory {
    private final ScanQuery query;
    @Nullable
    private final AtomicLong runningCountForLimit;

    @JsonCreator
    public ScanQueryFrameProcessorFactory(@JsonProperty(value="query") ScanQuery query) {
        this.query = (ScanQuery)Preconditions.checkNotNull((Object)query, (Object)"query");
        this.runningCountForLimit = query.isLimited() && query.getOrderBys().isEmpty() ? new AtomicLong() : null;
    }

    @JsonProperty
    public ScanQuery getQuery() {
        return this.query;
    }

    @Override
    protected FrameProcessor<Long> makeProcessor(ReadableInput baseInput, Int2ObjectMap<ReadableInput> sideChannels, ResourceHolder<WritableFrameChannel> outputChannelHolder, ResourceHolder<MemoryAllocator> allocatorHolder, RowSignature signature, ClusterBy clusterBy, FrameContext frameContext) {
        return new ScanQueryFrameProcessor(this.query, baseInput, sideChannels, new JoinableFactoryWrapper(frameContext.joinableFactory()), outputChannelHolder, new LazyResourceHolder<FrameWriterFactory>(() -> Pair.of((Object)FrameWriters.makeFrameWriterFactory((FrameType)FrameType.ROW_BASED, (MemoryAllocator)((MemoryAllocator)allocatorHolder.get()), (RowSignature)signature, (List)clusterBy.getColumns()), (Object)allocatorHolder)), this.runningCountForLimit, frameContext.memoryParameters().getBroadcastJoinMemory(), frameContext.jsonMapper());
    }
}

