/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.scan;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameRowTooLargeException;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameSegment;
import org.apache.druid.frame.util.SettableLongVirtualColumn;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.table.SegmentWithDescriptor;
import org.apache.druid.msq.querykit.BaseLeafFrameProcessor;
import org.apache.druid.msq.querykit.QueryKitUtils;
import org.apache.druid.query.Query;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.scan.ScanQuery;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.StorageAdapter;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class ScanQueryFrameProcessor
extends BaseLeafFrameProcessor {
    private final ScanQuery query;
    private final AtomicLong runningCountForLimit;
    private final SettableLongVirtualColumn partitionBoostVirtualColumn;
    private final VirtualColumns frameWriterVirtualColumns;
    private final Closer closer = Closer.create();
    private long rowsOutput = 0L;
    private Cursor cursor;
    private FrameWriter frameWriter;
    private long currentAllocatorCapacity;

    public ScanQueryFrameProcessor(ScanQuery query, ReadableInput baseInput, Int2ObjectMap<ReadableInput> sideChannels, JoinableFactoryWrapper joinableFactory, ResourceHolder<WritableFrameChannel> outputChannel, ResourceHolder<FrameWriterFactory> frameWriterFactoryHolder, @Nullable AtomicLong runningCountForLimit, long memoryReservedForBroadcastJoin, ObjectMapper jsonMapper) {
        super((Query<?>)query, baseInput, sideChannels, joinableFactory, outputChannel, frameWriterFactoryHolder, memoryReservedForBroadcastJoin);
        this.query = query;
        this.runningCountForLimit = runningCountForLimit;
        this.partitionBoostVirtualColumn = new SettableLongVirtualColumn("__boost");
        ArrayList<Object> frameWriterVirtualColumns = new ArrayList<Object>();
        frameWriterVirtualColumns.add(this.partitionBoostVirtualColumn);
        VirtualColumn segmentGranularityVirtualColumn = QueryKitUtils.makeSegmentGranularityVirtualColumn(jsonMapper, query);
        if (segmentGranularityVirtualColumn != null) {
            frameWriterVirtualColumns.add(segmentGranularityVirtualColumn);
        }
        this.frameWriterVirtualColumns = VirtualColumns.create(frameWriterVirtualColumns);
    }

    @Override
    public ReturnOrAwait<Long> runIncrementally(IntSet readableInputs) throws IOException {
        boolean legacy = (Boolean)Preconditions.checkNotNull((Object)this.query.isLegacy(), (Object)"Expected non-null 'legacy' parameter");
        if (legacy) {
            throw new ISE("Cannot use this engine in legacy mode", new Object[0]);
        }
        if (this.runningCountForLimit != null && this.runningCountForLimit.get() > this.query.getScanRowsOffset() + this.query.getScanRowsLimit()) {
            return ReturnOrAwait.returnObject((Object)this.rowsOutput);
        }
        return super.runIncrementally(readableInputs);
    }

    @Override
    public void cleanup() throws IOException {
        this.closer.register((Closeable)this.frameWriter);
        this.closer.register(() -> super.cleanup());
        this.closer.close();
    }

    @Override
    protected ReturnOrAwait<Long> runWithSegment(SegmentWithDescriptor segment) throws IOException {
        if (this.cursor == null) {
            this.closer.register((Closeable)segment);
            Yielder cursorYielder = Yielders.each(ScanQueryFrameProcessor.makeCursors(this.query.withQuerySegmentSpec((QuerySegmentSpec)new SpecificSegmentSpec(segment.getDescriptor())), this.mapSegment(segment.getOrLoadSegment()).asStorageAdapter()));
            if (cursorYielder.isDone()) {
                cursorYielder.close();
                return ReturnOrAwait.returnObject((Object)this.rowsOutput);
            }
            long rowsFlushed = this.setNextCursor((Cursor)cursorYielder.get());
            assert (rowsFlushed == 0L);
            this.closer.register((Closeable)cursorYielder);
        }
        this.populateFrameWriterAndFlushIfNeeded();
        if (this.cursor.isDone()) {
            this.flushFrameWriter();
        }
        if (this.cursor.isDone() && (this.frameWriter == null || this.frameWriter.getNumRows() == 0)) {
            return ReturnOrAwait.returnObject((Object)this.rowsOutput);
        }
        return ReturnOrAwait.runAgain();
    }

    @Override
    protected ReturnOrAwait<Long> runWithInputChannel(ReadableFrameChannel inputChannel, FrameReader inputFrameReader) throws IOException {
        if (this.cursor == null || this.cursor.isDone()) {
            if (inputChannel.canRead()) {
                Frame frame = inputChannel.read();
                FrameSegment frameSegment = new FrameSegment(frame, inputFrameReader, SegmentId.dummy((String)"scan"));
                long rowsFlushed = this.setNextCursor((Cursor)Iterables.getOnlyElement((Iterable)ScanQueryFrameProcessor.makeCursors(this.query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Intervals.ONLY_ETERNITY)), this.mapSegment((Segment)frameSegment).asStorageAdapter()).toList()));
                if (rowsFlushed > 0L) {
                    return ReturnOrAwait.runAgain();
                }
            } else {
                if (inputChannel.isFinished()) {
                    this.flushFrameWriter();
                    return ReturnOrAwait.returnObject((Object)this.rowsOutput);
                }
                return ReturnOrAwait.awaitAll((int)this.inputChannels().size());
            }
        }
        this.populateFrameWriterAndFlushIfNeeded();
        if (this.cursor.isDone()) {
            return ReturnOrAwait.awaitAll((int)this.inputChannels().size());
        }
        return ReturnOrAwait.runAgain();
    }

    private void populateFrameWriterAndFlushIfNeeded() throws IOException {
        this.createFrameWriterIfNeeded();
        while (!this.cursor.isDone()) {
            if (!this.frameWriter.addSelection()) {
                if (this.frameWriter.getNumRows() > 0) {
                    long numRowsWritten = this.flushFrameWriter();
                    if (this.runningCountForLimit != null) {
                        this.runningCountForLimit.addAndGet(numRowsWritten);
                    }
                    return;
                }
                throw new FrameRowTooLargeException(this.currentAllocatorCapacity);
            }
            this.cursor.advance();
            this.partitionBoostVirtualColumn.setValue(this.partitionBoostVirtualColumn.getValue() + 1L);
        }
    }

    private void createFrameWriterIfNeeded() {
        if (this.frameWriter == null) {
            FrameWriterFactory frameWriterFactory = this.getFrameWriterFactory();
            ColumnSelectorFactory frameWriterColumnSelectorFactory = this.frameWriterVirtualColumns.wrap(this.cursor.getColumnSelectorFactory());
            this.frameWriter = frameWriterFactory.newFrameWriter(frameWriterColumnSelectorFactory);
            this.currentAllocatorCapacity = frameWriterFactory.allocatorCapacity();
        }
    }

    private long flushFrameWriter() throws IOException {
        if (this.frameWriter != null && this.frameWriter.getNumRows() > 0) {
            Frame frame = Frame.wrap((byte[])this.frameWriter.toByteArray());
            ((WritableFrameChannel)Iterables.getOnlyElement(this.outputChannels())).write(new FrameWithPartition(frame, -1));
            this.frameWriter.close();
            this.frameWriter = null;
            this.rowsOutput += (long)frame.numRows();
            return frame.numRows();
        }
        if (this.frameWriter != null) {
            this.frameWriter.close();
            this.frameWriter = null;
        }
        return 0L;
    }

    private long setNextCursor(Cursor cursor) throws IOException {
        long rowsFlushed = this.flushFrameWriter();
        this.cursor = cursor;
        return rowsFlushed;
    }

    private static Sequence<Cursor> makeCursors(ScanQuery query, StorageAdapter adapter) {
        if (adapter == null) {
            throw new ISE("Null storage adapter found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
        }
        List intervals = query.getQuerySegmentSpec().getIntervals();
        Preconditions.checkArgument((intervals.size() == 1 ? 1 : 0) != 0, (String)"Can only handle a single interval, got[%s]", (Object[])new Object[]{intervals});
        Filter filter = Filters.convertToCNFFromQueryContext((Query)query, (Filter)Filters.toFilter((DimFilter)query.getFilter()));
        return adapter.makeCursors(filter, (Interval)intervals.get(0), query.getVirtualColumns(), Granularities.ALL, ScanQuery.Order.DESCENDING.equals((Object)query.getTimeOrder()), null);
    }
}

