/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Optional;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.SortColumn;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.msq.input.stage.StageInputSpec;
import org.apache.druid.msq.kernel.MaxCountShuffleSpec;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.QueryDefinitionBuilder;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.querykit.DataSourcePlan;
import org.apache.druid.msq.querykit.QueryKit;
import org.apache.druid.msq.querykit.QueryKitUtils;
import org.apache.druid.msq.querykit.ShuffleSpecFactories;
import org.apache.druid.msq.querykit.ShuffleSpecFactory;
import org.apache.druid.msq.querykit.common.OffsetLimitFrameProcessorFactory;
import org.apache.druid.msq.querykit.groupby.GroupByPostShuffleFrameProcessorFactory;
import org.apache.druid.msq.querykit.groupby.GroupByPreShuffleFrameProcessorFactory;
import org.apache.druid.query.Query;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.having.AlwaysHavingSpec;
import org.apache.druid.query.groupby.having.DimFilterHavingSpec;
import org.apache.druid.query.groupby.orderby.DefaultLimitSpec;
import org.apache.druid.query.groupby.orderby.NoopLimitSpec;
import org.apache.druid.query.groupby.orderby.OrderByColumnSpec;
import org.apache.druid.query.ordering.StringComparator;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.ValueType;

public class GroupByQueryKit
implements QueryKit<GroupByQuery> {
    private final ObjectMapper jsonMapper;

    public GroupByQueryKit(ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Override
    public QueryDefinition makeQueryDefinition(String queryId, GroupByQuery originalQuery, QueryKit<Query<?>> queryKit, ShuffleSpecFactory resultShuffleSpecFactory, int maxWorkerCount, int minStageNumber) {
        ShuffleSpecFactory shuffleSpecFactoryPostAggregation;
        ShuffleSpecFactory shuffleSpecFactoryPreAggregation;
        boolean doLimitOrOffset;
        GroupByQueryKit.validateQuery(originalQuery);
        QueryDefinitionBuilder queryDefBuilder = QueryDefinition.builder().queryId(queryId);
        DataSourcePlan dataSourcePlan = DataSourcePlan.forDataSource(queryKit, queryId, originalQuery.getDataSource(), originalQuery.getQuerySegmentSpec(), originalQuery.getFilter(), maxWorkerCount, minStageNumber, false);
        dataSourcePlan.getSubQueryDefBuilder().ifPresent(queryDefBuilder::addAll);
        GroupByQuery queryToRun = (GroupByQuery)originalQuery.withDataSource(dataSourcePlan.getNewDataSource());
        int firstStageNumber = Math.max(minStageNumber, queryDefBuilder.getNextStageNumber());
        Granularity segmentGranularity = QueryKitUtils.getSegmentGranularityFromContext(this.jsonMapper, queryToRun.getContext());
        RowSignature intermediateSignature = GroupByQueryKit.computeIntermediateSignature(queryToRun);
        ClusterBy resultClusterBy = QueryKitUtils.clusterByWithSegmentGranularity(GroupByQueryKit.computeClusterByForResults(queryToRun), segmentGranularity);
        RowSignature resultSignature = QueryKitUtils.sortableSignature(QueryKitUtils.signatureWithSegmentGranularity(GroupByQueryKit.computeResultSignature(queryToRun), segmentGranularity), resultClusterBy.getColumns());
        ClusterBy intermediateClusterBy = GroupByQueryKit.computeIntermediateClusterBy(queryToRun);
        boolean doOrderBy = !resultClusterBy.equals((Object)intermediateClusterBy);
        boolean bl = doLimitOrOffset = queryToRun.getLimitSpec() instanceof DefaultLimitSpec && (((DefaultLimitSpec)queryToRun.getLimitSpec()).isLimited() || ((DefaultLimitSpec)queryToRun.getLimitSpec()).isOffset());
        if (intermediateClusterBy.getColumns().isEmpty()) {
            shuffleSpecFactoryPreAggregation = ShuffleSpecFactories.singlePartition();
            shuffleSpecFactoryPostAggregation = ShuffleSpecFactories.singlePartition();
        } else if (doOrderBy) {
            shuffleSpecFactoryPreAggregation = ShuffleSpecFactories.subQueryWithMaxWorkerCount(maxWorkerCount);
            shuffleSpecFactoryPostAggregation = doLimitOrOffset ? ShuffleSpecFactories.singlePartition() : resultShuffleSpecFactory;
        } else {
            shuffleSpecFactoryPreAggregation = doLimitOrOffset ? ShuffleSpecFactories.singlePartition() : resultShuffleSpecFactory;
            shuffleSpecFactoryPostAggregation = null;
        }
        queryDefBuilder.add(StageDefinition.builder(firstStageNumber).inputs(dataSourcePlan.getInputSpecs()).broadcastInputs(dataSourcePlan.getBroadcastInputs()).signature(intermediateSignature).shuffleSpec(shuffleSpecFactoryPreAggregation.build(intermediateClusterBy, true)).maxWorkerCount(dataSourcePlan.isSingleWorker() ? 1 : maxWorkerCount).processorFactory(new GroupByPreShuffleFrameProcessorFactory(queryToRun)));
        queryDefBuilder.add(StageDefinition.builder(firstStageNumber + 1).inputs(new StageInputSpec(firstStageNumber)).signature(resultSignature).maxWorkerCount(maxWorkerCount).shuffleSpec(shuffleSpecFactoryPostAggregation != null ? shuffleSpecFactoryPostAggregation.build(resultClusterBy, false) : null).processorFactory(new GroupByPostShuffleFrameProcessorFactory(queryToRun)));
        if (doLimitOrOffset) {
            DefaultLimitSpec limitSpec = (DefaultLimitSpec)queryToRun.getLimitSpec();
            queryDefBuilder.add(StageDefinition.builder(firstStageNumber + 2).inputs(new StageInputSpec(firstStageNumber + 1)).signature(resultSignature).maxWorkerCount(1).shuffleSpec(new MaxCountShuffleSpec(ClusterBy.none(), 1, false)).processorFactory(new OffsetLimitFrameProcessorFactory(limitSpec.getOffset(), limitSpec.isLimited() ? Long.valueOf(limitSpec.getLimit()) : null)));
        }
        return queryDefBuilder.queryId(queryId).build();
    }

    static RowSignature computeIntermediateSignature(GroupByQuery query) {
        RowSignature postAggregationSignature = query.getResultRowSignature(RowSignature.Finalization.NO);
        RowSignature.Builder builder = RowSignature.builder();
        for (int i = 0; i < query.getResultRowSizeWithoutPostAggregators(); ++i) {
            builder.add(postAggregationSignature.getColumnName(i), (ColumnType)postAggregationSignature.getColumnType(i).orElse(null));
        }
        return builder.build();
    }

    static RowSignature computeResultSignature(GroupByQuery query) {
        RowSignature.Finalization finalization = GroupByQueryKit.isFinalize(query) ? RowSignature.Finalization.YES : RowSignature.Finalization.NO;
        return query.getResultRowSignature(finalization);
    }

    static boolean isFinalize(GroupByQuery query) {
        return query.context().isFinalize(true);
    }

    static ClusterBy computeIntermediateClusterBy(GroupByQuery query) {
        ArrayList<SortColumn> columns = new ArrayList<SortColumn>();
        for (DimensionSpec dimension : query.getDimensions()) {
            columns.add(new SortColumn(dimension.getOutputName(), false));
        }
        return new ClusterBy(columns, 0);
    }

    static ClusterBy computeClusterByForResults(GroupByQuery query) {
        DefaultLimitSpec defaultLimitSpec;
        if (query.getLimitSpec() instanceof DefaultLimitSpec && !(defaultLimitSpec = (DefaultLimitSpec)query.getLimitSpec()).getColumns().isEmpty()) {
            ArrayList<SortColumn> clusterByColumns = new ArrayList<SortColumn>();
            for (OrderByColumnSpec orderBy : defaultLimitSpec.getColumns()) {
                clusterByColumns.add(new SortColumn(orderBy.getDimension(), orderBy.getDirection() == OrderByColumnSpec.Direction.DESCENDING));
            }
            return new ClusterBy(clusterByColumns, 0);
        }
        return GroupByQueryKit.computeIntermediateClusterBy(query);
    }

    private static void validateQuery(GroupByQuery query) {
        Preconditions.checkState((!query.getContextSortByDimsFirst() ? 1 : 0) != 0, (Object)"Must not sort by dims first");
        Preconditions.checkState((query.getSubtotalsSpec() == null ? 1 : 0) != 0, (Object)"Must not have 'subtotalsSpec'");
        Preconditions.checkState((query.getHavingSpec() == null || query.getHavingSpec() instanceof DimFilterHavingSpec || query.getHavingSpec() instanceof AlwaysHavingSpec ? 1 : 0) != 0, (Object)"Must use 'filter' or 'always' havingSpec");
        Preconditions.checkState((boolean)query.getGranularity().equals(Granularities.ALL), (Object)"Must have granularity 'all'");
        Preconditions.checkState((query.getLimitSpec() instanceof NoopLimitSpec || query.getLimitSpec() instanceof DefaultLimitSpec ? 1 : 0) != 0, (Object)"Must have noop or default limitSpec");
        RowSignature resultSignature = GroupByQueryKit.computeResultSignature(query);
        QueryKitUtils.verifyRowSignature(resultSignature);
        if (query.getLimitSpec() instanceof DefaultLimitSpec) {
            DefaultLimitSpec defaultLimitSpec = (DefaultLimitSpec)query.getLimitSpec();
            for (OrderByColumnSpec column : defaultLimitSpec.getColumns()) {
                Optional type = resultSignature.getColumnType(column.getDimension());
                if (type.isPresent() && GroupByQueryKit.isNaturalComparator((ValueType)((ColumnType)type.get()).getType(), column.getDimensionComparator())) continue;
                throw new ISE("Must use natural comparator for column [%s] of type [%s]", new Object[]{column.getDimension(), type.orElse(null)});
            }
        }
    }

    private static boolean isNaturalComparator(ValueType type, StringComparator comparator) {
        return (type == ValueType.STRING && StringComparators.LEXICOGRAPHIC.equals(comparator) || type.isNumeric() && StringComparators.NUMERIC.equals(comparator)) && !type.isArray();
    }
}

