/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.groupby;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameRowTooLargeException;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.segment.FrameSegment;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.table.SegmentWithDescriptor;
import org.apache.druid.msq.querykit.BaseLeafFrameProcessor;
import org.apache.druid.query.Query;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.RowBasedGrouperHelper;
import org.apache.druid.query.groupby.strategy.GroupByStrategySelector;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.timeline.SegmentId;

public class GroupByPreShuffleFrameProcessor
extends BaseLeafFrameProcessor {
    private final GroupByQuery query;
    private final GroupByStrategySelector strategySelector;
    private final ColumnSelectorFactory frameWriterColumnSelectorFactory;
    private final Closer closer = Closer.create();
    private Yielder<ResultRow> resultYielder;
    private FrameWriter frameWriter;
    private long rowsOutput;
    private long currentAllocatorCapacity;

    public GroupByPreShuffleFrameProcessor(GroupByQuery query, ReadableInput baseInput, Int2ObjectMap<ReadableInput> sideChannels, GroupByStrategySelector strategySelector, JoinableFactoryWrapper joinableFactory, ResourceHolder<WritableFrameChannel> outputChannel, ResourceHolder<FrameWriterFactory> frameWriterFactoryHolder, long memoryReservedForBroadcastJoin) {
        super((Query<?>)query, baseInput, sideChannels, joinableFactory, outputChannel, frameWriterFactoryHolder, memoryReservedForBroadcastJoin);
        this.query = query;
        this.strategySelector = strategySelector;
        this.frameWriterColumnSelectorFactory = RowBasedGrouperHelper.createResultRowBasedColumnSelectorFactory((GroupByQuery)query, () -> (ResultRow)this.resultYielder.get(), (RowSignature.Finalization)RowSignature.Finalization.NO);
    }

    @Override
    protected ReturnOrAwait<Long> runWithSegment(SegmentWithDescriptor segment) throws IOException {
        if (this.resultYielder == null) {
            this.closer.register((Closeable)segment);
            Sequence rowSequence = this.strategySelector.strategize(this.query).process(this.query.withQuerySegmentSpec((QuerySegmentSpec)new SpecificSegmentSpec(segment.getDescriptor())), this.mapSegment(segment.getOrLoadSegment()).asStorageAdapter(), null);
            this.resultYielder = Yielders.each((Sequence)rowSequence);
        }
        this.populateFrameWriterAndFlushIfNeeded();
        if (this.resultYielder == null || this.resultYielder.isDone()) {
            return ReturnOrAwait.returnObject((Object)this.rowsOutput);
        }
        return ReturnOrAwait.runAgain();
    }

    @Override
    protected ReturnOrAwait<Long> runWithInputChannel(ReadableFrameChannel inputChannel, FrameReader inputFrameReader) throws IOException {
        if (this.resultYielder == null || this.resultYielder.isDone()) {
            this.closeAndDiscardResultYielder();
            if (inputChannel.canRead()) {
                Frame frame = inputChannel.read();
                FrameSegment frameSegment = new FrameSegment(frame, inputFrameReader, SegmentId.dummy((String)"x"));
                Sequence rowSequence = this.strategySelector.strategize(this.query).process(this.query.withQuerySegmentSpec((QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Intervals.ONLY_ETERNITY)), this.mapSegment((Segment)frameSegment).asStorageAdapter(), null);
                this.resultYielder = Yielders.each((Sequence)rowSequence);
            } else {
                if (inputChannel.isFinished()) {
                    this.flushFrameWriterIfNeeded();
                    return ReturnOrAwait.returnObject((Object)this.rowsOutput);
                }
                return ReturnOrAwait.awaitAll((int)this.inputChannels().size());
            }
        }
        this.populateFrameWriterAndFlushIfNeeded();
        if (this.resultYielder == null || this.resultYielder.isDone()) {
            this.closeAndDiscardResultYielder();
            return ReturnOrAwait.awaitAll((int)this.inputChannels().size());
        }
        return ReturnOrAwait.runAgain();
    }

    @Override
    public void cleanup() throws IOException {
        this.closer.register(this::closeAndDiscardResultYielder);
        this.closer.register((Closeable)this.frameWriter);
        this.closer.register(() -> super.cleanup());
        this.closer.close();
    }

    private void populateFrameWriterAndFlushIfNeeded() throws IOException {
        this.createFrameWriterIfNeeded();
        while (!this.resultYielder.isDone()) {
            boolean didAddToFrame = this.frameWriter.addSelection();
            if (didAddToFrame) {
                this.resultYielder = this.resultYielder.next(null);
                continue;
            }
            if (this.frameWriter.getNumRows() == 0) {
                throw new FrameRowTooLargeException(this.currentAllocatorCapacity);
            }
            this.flushFrameWriterIfNeeded();
            return;
        }
        this.flushFrameWriterIfNeeded();
        this.closeAndDiscardResultYielder();
    }

    private void createFrameWriterIfNeeded() {
        if (this.frameWriter == null) {
            FrameWriterFactory frameWriterFactory = this.getFrameWriterFactory();
            this.frameWriter = frameWriterFactory.newFrameWriter(this.frameWriterColumnSelectorFactory);
            this.currentAllocatorCapacity = frameWriterFactory.allocatorCapacity();
        }
    }

    private void flushFrameWriterIfNeeded() throws IOException {
        if (this.frameWriter != null && this.frameWriter.getNumRows() > 0) {
            Frame frame = Frame.wrap((byte[])this.frameWriter.toByteArray());
            ((WritableFrameChannel)Iterables.getOnlyElement(this.outputChannels())).write(new FrameWithPartition(frame, -1));
            this.frameWriter.close();
            this.frameWriter = null;
            this.rowsOutput += (long)frame.numRows();
        }
    }

    private void closeAndDiscardResultYielder() throws IOException {
        Yielder<ResultRow> tmp = this.resultYielder;
        this.resultYielder = null;
        if (tmp != null) {
            tmp.close();
        }
    }
}

