/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit.groupby;

import com.fasterxml.jackson.databind.ObjectMapper;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.FrameRowTooLargeException;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.write.FrameWriter;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.msq.querykit.QueryKitUtils;
import org.apache.druid.msq.querykit.groupby.GroupByQueryKit;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.ResultRow;
import org.apache.druid.query.groupby.epinephelinae.RowBasedGrouperHelper;
import org.apache.druid.query.groupby.having.AlwaysHavingSpec;
import org.apache.druid.query.groupby.having.DimFilterHavingSpec;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.query.groupby.strategy.GroupByStrategySelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.RowSignature;

public class GroupByPostShuffleFrameProcessor
implements FrameProcessor<Long> {
    private final GroupByQuery query;
    private final ReadableFrameChannel inputChannel;
    private final WritableFrameChannel outputChannel;
    private final MemoryAllocator allocator;
    private final FrameReader frameReader;
    private final RowSignature resultSignature;
    private final ClusterBy clusterBy;
    private final ColumnSelectorFactory columnSelectorFactoryForFrameWriter;
    private final Comparator<ResultRow> compareFn;
    private final BinaryOperator<ResultRow> mergeFn;
    private final Consumer<ResultRow> finalizeFn;
    @Nullable
    private final HavingSpec havingSpec;
    private Cursor frameCursor = null;
    private Supplier<ResultRow> rowSupplierFromFrameCursor;
    private ResultRow outputRow = null;
    private FrameWriter frameWriter = null;

    public GroupByPostShuffleFrameProcessor(GroupByQuery query, GroupByStrategySelector strategySelector, ReadableFrameChannel inputChannel, WritableFrameChannel outputChannel, FrameReader frameReader, RowSignature resultSignature, ClusterBy clusterBy, MemoryAllocator allocator, ObjectMapper jsonMapper) {
        this.query = query;
        this.inputChannel = inputChannel;
        this.outputChannel = outputChannel;
        this.frameReader = frameReader;
        this.resultSignature = resultSignature;
        this.clusterBy = clusterBy;
        this.allocator = allocator;
        this.compareFn = strategySelector.strategize(query).createResultComparator((Query)query);
        this.mergeFn = strategySelector.strategize(query).createMergeFn((Query)query);
        this.finalizeFn = GroupByPostShuffleFrameProcessor.makeFinalizeFn(query);
        this.havingSpec = GroupByPostShuffleFrameProcessor.cloneHavingSpec(query);
        this.columnSelectorFactoryForFrameWriter = GroupByPostShuffleFrameProcessor.makeVirtualColumnsForFrameWriter(jsonMapper, query).wrap(RowBasedGrouperHelper.createResultRowBasedColumnSelectorFactory((GroupByQuery)query, () -> this.outputRow, (RowSignature.Finalization)RowSignature.Finalization.YES));
    }

    public List<ReadableFrameChannel> inputChannels() {
        return Collections.singletonList(this.inputChannel);
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.singletonList(this.outputChannel);
    }

    public ReturnOrAwait<Long> runIncrementally(IntSet readableInputs) throws IOException {
        if (this.frameCursor == null || this.frameCursor.isDone()) {
            if (readableInputs.isEmpty()) {
                return ReturnOrAwait.awaitAll((int)1);
            }
            if (this.inputChannel.isFinished()) {
                if (this.outputRow != null && this.writeOutputRow()) {
                    return ReturnOrAwait.runAgain();
                }
                this.writeCurrentFrameIfNeeded();
                return ReturnOrAwait.returnObject((Object)0L);
            }
            Frame frame = this.inputChannel.read();
            this.frameCursor = FrameProcessors.makeCursor((Frame)frame, (FrameReader)this.frameReader);
            ColumnSelectorFactory frameColumnSelectorFactory = this.frameCursor.getColumnSelectorFactory();
            Supplier[] fieldSuppliers = new Supplier[this.query.getResultRowSizeWithoutPostAggregators()];
            for (int i = 0; i < fieldSuppliers.length; ++i) {
                ColumnValueSelector selector = frameColumnSelectorFactory.makeColumnValueSelector(this.frameReader.signature().getColumnName(i));
                fieldSuppliers[i] = () -> ((ColumnValueSelector)selector).getObject();
            }
            int fullRowSize = this.query.getResultRowSignature().size();
            this.rowSupplierFromFrameCursor = () -> {
                int i;
                ResultRow row = ResultRow.create((int)fullRowSize);
                for (i = 0; i < fieldSuppliers.length; ++i) {
                    row.set(i, fieldSuppliers[i].get());
                }
                for (i = fieldSuppliers.length; i < fullRowSize; ++i) {
                    row.set(i, null);
                }
                return row;
            };
        }
        this.setUpFrameWriterIfNeeded();
        while (!this.frameCursor.isDone()) {
            ResultRow currentRow = this.rowSupplierFromFrameCursor.get();
            if (this.outputRow == null) {
                this.outputRow = currentRow.copy();
            } else if (this.compareFn.compare(this.outputRow, currentRow) == 0) {
                this.outputRow = (ResultRow)this.mergeFn.apply(this.outputRow, currentRow);
            } else {
                if (this.writeOutputRow()) {
                    return ReturnOrAwait.runAgain();
                }
                this.outputRow = currentRow.copy();
            }
            this.frameCursor.advance();
        }
        return ReturnOrAwait.runAgain();
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), (Closeable[])new Closeable[]{this.frameWriter});
    }

    private boolean writeOutputRow() throws IOException {
        int resultRowSize = this.query.getResultRowSignature().size();
        if (this.outputRow.length() < resultRowSize) {
            Object[] newArray = new Object[resultRowSize];
            System.arraycopy(this.outputRow.getArray(), 0, newArray, 0, this.outputRow.length());
            this.outputRow = ResultRow.of((Object[])newArray);
        }
        Map outputRowAsMap = this.outputRow.toMap(this.query);
        for (int i = 0; i < this.query.getPostAggregatorSpecs().size(); ++i) {
            PostAggregator postAggregator = (PostAggregator)this.query.getPostAggregatorSpecs().get(i);
            Object value = postAggregator.compute(outputRowAsMap);
            this.outputRow.set(this.query.getResultRowPostAggregatorStart() + i, value);
            outputRowAsMap.put(postAggregator.getName(), value);
        }
        this.finalizeFn.accept(this.outputRow);
        if (this.havingSpec != null && !this.havingSpec.eval(this.outputRow)) {
            this.outputRow = null;
            return false;
        }
        if (this.frameWriter.addSelection()) {
            this.outputRow = null;
            return false;
        }
        if (this.frameWriter.getNumRows() > 0) {
            this.writeCurrentFrameIfNeeded();
            this.setUpFrameWriterIfNeeded();
            if (this.frameWriter.addSelection()) {
                this.outputRow = null;
                return true;
            }
            throw new FrameRowTooLargeException(this.allocator.capacity());
        }
        throw new FrameRowTooLargeException(this.allocator.capacity());
    }

    private void writeCurrentFrameIfNeeded() throws IOException {
        if (this.frameWriter != null && this.frameWriter.getNumRows() > 0) {
            Frame frame = Frame.wrap((byte[])this.frameWriter.toByteArray());
            this.outputChannel.write(new FrameWithPartition(frame, -1));
            this.frameWriter.close();
            this.frameWriter = null;
        }
    }

    private void setUpFrameWriterIfNeeded() {
        if (this.frameWriter == null) {
            FrameWriterFactory frameWriterFactory = FrameWriters.makeFrameWriterFactory((FrameType)FrameType.ROW_BASED, (MemoryAllocator)this.allocator, (RowSignature)this.resultSignature, (List)this.clusterBy.getColumns());
            this.frameWriter = frameWriterFactory.newFrameWriter(this.columnSelectorFactoryForFrameWriter);
        }
    }

    private static Consumer<ResultRow> makeFinalizeFn(GroupByQuery query) {
        if (GroupByQueryKit.isFinalize(query)) {
            int startIndex = query.getResultRowAggregatorStart();
            List aggregators = query.getAggregatorSpecs();
            return row -> {
                for (int i = 0; i < aggregators.size(); ++i) {
                    row.set(startIndex + i, ((AggregatorFactory)aggregators.get(i)).finalizeComputation(row.get(startIndex + i)));
                }
            };
        }
        return row -> {};
    }

    @Nullable
    private static HavingSpec cloneHavingSpec(GroupByQuery query) {
        if (query.getHavingSpec() == null || query.getHavingSpec() instanceof AlwaysHavingSpec) {
            return null;
        }
        if (query.getHavingSpec() instanceof DimFilterHavingSpec) {
            DimFilterHavingSpec dimFilterHavingSpec = (DimFilterHavingSpec)query.getHavingSpec();
            DimFilterHavingSpec clonedHavingSpec = new DimFilterHavingSpec(dimFilterHavingSpec.getDimFilter(), Boolean.valueOf(dimFilterHavingSpec.isFinalize()));
            clonedHavingSpec.setQuery(query);
            return clonedHavingSpec;
        }
        throw new UnsupportedOperationException("Must use 'filter' or 'always' havingSpec");
    }

    private static VirtualColumns makeVirtualColumnsForFrameWriter(ObjectMapper jsonMapper, GroupByQuery query) {
        VirtualColumn segmentGranularityVirtualColumn = QueryKitUtils.makeSegmentGranularityVirtualColumn(jsonMapper, query);
        if (segmentGranularityVirtualColumn == null) {
            return VirtualColumns.EMPTY;
        }
        return VirtualColumns.create(Collections.singletonList(segmentGranularityVirtualColumn));
    }
}

