/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.google.common.base.Preconditions;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.querykit.QueryKit;
import org.apache.druid.msq.querykit.ShuffleSpecFactory;
import org.apache.druid.query.Query;

public class MultiQueryKit
implements QueryKit<Query<?>> {
    private final Map<Class<? extends Query>, QueryKit> toolKitMap;

    public MultiQueryKit(Map<Class<? extends Query>, QueryKit> toolKitMap) {
        this.toolKitMap = (Map)Preconditions.checkNotNull(toolKitMap, (Object)"toolKitMap");
    }

    @Override
    public QueryDefinition makeQueryDefinition(String queryId, Query<?> query, QueryKit<Query<?>> toolKitForSubQueries, ShuffleSpecFactory resultShuffleSpecFactory, int maxWorkerCount, int minStageNumber) {
        QueryKit specificToolKit = this.toolKitMap.get(query.getClass());
        if (specificToolKit != null) {
            return specificToolKit.makeQueryDefinition(queryId, query, this, resultShuffleSpecFactory, maxWorkerCount, minStageNumber);
        }
        throw new ISE("Unsupported query class [%s]", new Object[]{query.getClass().getName()});
    }
}

