/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.logger.Logger;

@NotThreadSafe
public class LazyResourceHolder<T>
implements ResourceHolder<T> {
    private static final Logger log = new Logger(LazyResourceHolder.class);
    private final Supplier<Pair<T, Closeable>> supplier;
    private T resource = null;
    private Closeable closer = null;

    public LazyResourceHolder(Supplier<Pair<T, Closeable>> supplier) {
        this.supplier = (Supplier)Preconditions.checkNotNull(supplier, (Object)"supplier");
    }

    public T get() {
        if (this.resource == null) {
            Pair<T, Closeable> supplied = this.supplier.get();
            this.resource = Preconditions.checkNotNull((Object)supplied.lhs, (Object)"resource");
            this.closer = (Closeable)Preconditions.checkNotNull((Object)supplied.rhs, (Object)"closer");
        }
        return this.resource;
    }

    public void close() {
        if (this.resource != null) {
            try {
                this.closer.close();
            }
            catch (Throwable e) {
                log.noStackTrace().warn(e, "Exception encountered while closing resource: %s", new Object[]{this.resource});
            }
            finally {
                this.resource = null;
                this.closer = null;
            }
        }
    }
}

