/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.data.input.impl.JsonInputFormat;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.NilInputSource;
import org.apache.druid.msq.input.external.ExternalInputSpec;
import org.apache.druid.msq.input.stage.StageInputSpec;
import org.apache.druid.msq.input.table.TableInputSpec;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.QueryDefinitionBuilder;
import org.apache.druid.msq.querykit.InputNumberDataSource;
import org.apache.druid.msq.querykit.QueryKit;
import org.apache.druid.msq.querykit.ShuffleSpecFactories;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.query.planning.PreJoinableClause;
import org.apache.druid.query.spec.MultipleIntervalSegmentSpec;
import org.apache.druid.query.spec.QuerySegmentSpec;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.JoinType;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.sql.calcite.external.ExternalDataSource;
import org.joda.time.Interval;

public class DataSourcePlan {
    private static final Map<String, Object> CONTEXT_MAP_NO_SEGMENT_GRANULARITY = new HashMap<String, Object>();
    private final DataSource newDataSource;
    private final List<InputSpec> inputSpecs;
    private final IntSet broadcastInputs;
    @Nullable
    private final QueryDefinitionBuilder subQueryDefBuilder;

    DataSourcePlan(DataSource newDataSource, List<InputSpec> inputSpecs, IntSet broadcastInputs, @Nullable QueryDefinitionBuilder subQueryDefBuilder) {
        this.newDataSource = (DataSource)Preconditions.checkNotNull((Object)newDataSource, (Object)"newDataSource");
        this.inputSpecs = (List)Preconditions.checkNotNull(inputSpecs, (Object)"inputSpecs");
        this.broadcastInputs = (IntSet)Preconditions.checkNotNull((Object)broadcastInputs, (Object)"broadcastInputs");
        this.subQueryDefBuilder = subQueryDefBuilder;
        IntIterator intIterator = broadcastInputs.iterator();
        while (intIterator.hasNext()) {
            int broadcastInput = (Integer)intIterator.next();
            if (broadcastInput >= 0 && broadcastInput < inputSpecs.size()) continue;
            throw new IAE("Broadcast input number [%d] out of range [0, %d)", new Object[]{broadcastInput, inputSpecs.size()});
        }
    }

    public static DataSourcePlan forDataSource(QueryKit queryKit, String queryId, DataSource dataSource, QuerySegmentSpec querySegmentSpec, @Nullable DimFilter filter, int maxWorkerCount, int minStageNumber, boolean broadcast) {
        if (dataSource instanceof TableDataSource) {
            return DataSourcePlan.forTable((TableDataSource)dataSource, DataSourcePlan.querySegmentSpecIntervals(querySegmentSpec), filter, broadcast);
        }
        if (dataSource instanceof ExternalDataSource) {
            DataSourcePlan.checkQuerySegmentSpecIsEternity(dataSource, querySegmentSpec);
            return DataSourcePlan.forExternal((ExternalDataSource)dataSource, broadcast);
        }
        if (dataSource instanceof InlineDataSource) {
            DataSourcePlan.checkQuerySegmentSpecIsEternity(dataSource, querySegmentSpec);
            return DataSourcePlan.forInline((InlineDataSource)dataSource, broadcast);
        }
        if (dataSource instanceof QueryDataSource) {
            DataSourcePlan.checkQuerySegmentSpecIsEternity(dataSource, querySegmentSpec);
            return DataSourcePlan.forQuery(queryKit, queryId, (QueryDataSource)dataSource, maxWorkerCount, minStageNumber, broadcast);
        }
        if (dataSource instanceof JoinDataSource) {
            return DataSourcePlan.forJoin(queryKit, queryId, (JoinDataSource)dataSource, querySegmentSpec, maxWorkerCount, minStageNumber, broadcast);
        }
        throw new UOE("Cannot handle dataSource [%s]", new Object[]{dataSource});
    }

    public DataSource getNewDataSource() {
        return this.newDataSource;
    }

    public List<InputSpec> getInputSpecs() {
        return this.inputSpecs;
    }

    public IntSet getBroadcastInputs() {
        return this.broadcastInputs;
    }

    public Optional<QueryDefinitionBuilder> getSubQueryDefBuilder() {
        return Optional.ofNullable(this.subQueryDefBuilder);
    }

    public boolean isSingleWorker() {
        return this.broadcastInputs.size() == this.inputSpecs.size();
    }

    private static DataSourcePlan forTable(TableDataSource dataSource, List<Interval> intervals, @Nullable DimFilter filter, boolean broadcast) {
        return new DataSourcePlan(new InputNumberDataSource(0), Collections.singletonList(new TableInputSpec(dataSource.getName(), intervals, filter)), (IntSet)(broadcast ? IntOpenHashSet.of((int)0) : IntSets.emptySet()), null);
    }

    private static DataSourcePlan forExternal(ExternalDataSource dataSource, boolean broadcast) {
        return new DataSourcePlan(new InputNumberDataSource(0), Collections.singletonList(new ExternalInputSpec(dataSource.getInputSource(), dataSource.getInputFormat(), dataSource.getSignature())), (IntSet)(broadcast ? IntOpenHashSet.of((int)0) : IntSets.emptySet()), null);
    }

    private static DataSourcePlan forInline(InlineDataSource dataSource, boolean broadcast) {
        ObjectMapper jsonMapper = new ObjectMapper(new JsonFactory());
        RowSignature signature = dataSource.getRowSignature();
        StringBuilder stringBuilder = new StringBuilder();
        for (Object[] rowArray : dataSource.getRows()) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            for (int i = 0; i < signature.size(); ++i) {
                m.put(signature.getColumnName(i), rowArray[i]);
            }
            try {
                stringBuilder.append(jsonMapper.writeValueAsString(m)).append('\n');
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        String dataString = stringBuilder.toString();
        return DataSourcePlan.forExternal(new ExternalDataSource((InputSource)(dataString.isEmpty() ? NilInputSource.instance() : new InlineInputSource(dataString)), (InputFormat)new JsonInputFormat(null, null, null, null, null), signature), broadcast);
    }

    private static DataSourcePlan forQuery(QueryKit queryKit, String queryId, QueryDataSource dataSource, int maxWorkerCount, int minStageNumber, boolean broadcast) {
        QueryDefinition subQueryDef = queryKit.makeQueryDefinition(queryId, dataSource.getQuery().withOverriddenContext(CONTEXT_MAP_NO_SEGMENT_GRANULARITY), queryKit, ShuffleSpecFactories.subQueryWithMaxWorkerCount(maxWorkerCount), maxWorkerCount, minStageNumber);
        int stageNumber = subQueryDef.getFinalStageDefinition().getStageNumber();
        return new DataSourcePlan(new InputNumberDataSource(0), Collections.singletonList(new StageInputSpec(stageNumber)), (IntSet)(broadcast ? IntOpenHashSet.of((int)0) : IntSets.emptySet()), QueryDefinition.builder(subQueryDef));
    }

    private static DataSourcePlan forJoin(QueryKit queryKit, String queryId, JoinDataSource dataSource, QuerySegmentSpec querySegmentSpec, int maxWorkerCount, int minStageNumber, boolean broadcast) {
        QueryDefinitionBuilder subQueryDefBuilder = QueryDefinition.builder();
        DataSourceAnalysis analysis = DataSourceAnalysis.forDataSource((DataSource)dataSource);
        DataSourcePlan basePlan = DataSourcePlan.forDataSource(queryKit, queryId, analysis.getBaseDataSource(), querySegmentSpec, null, maxWorkerCount, Math.max(minStageNumber, subQueryDefBuilder.getNextStageNumber()), broadcast);
        DataSource newDataSource = basePlan.getNewDataSource();
        ArrayList<InputSpec> inputSpecs = new ArrayList<InputSpec>(basePlan.getInputSpecs());
        IntOpenHashSet broadcastInputs = new IntOpenHashSet((IntCollection)basePlan.getBroadcastInputs());
        basePlan.getSubQueryDefBuilder().ifPresent(subQueryDefBuilder::addAll);
        for (int i = 0; i < analysis.getPreJoinableClauses().size(); ++i) {
            PreJoinableClause clause = (PreJoinableClause)analysis.getPreJoinableClauses().get(i);
            DataSourcePlan clausePlan = DataSourcePlan.forDataSource(queryKit, queryId, clause.getDataSource(), (QuerySegmentSpec)new MultipleIntervalSegmentSpec((List)Intervals.ONLY_ETERNITY), null, maxWorkerCount, Math.max(minStageNumber, subQueryDefBuilder.getNextStageNumber()), true);
            int shift = inputSpecs.size();
            newDataSource = JoinDataSource.create((DataSource)newDataSource, (DataSource)DataSourcePlan.shiftInputNumbers(clausePlan.getNewDataSource(), shift), (String)clause.getPrefix(), (JoinConditionAnalysis)clause.getCondition(), (JoinType)clause.getJoinType(), i == 0 ? (DimFilter)analysis.getJoinBaseTableFilter().orElse(null) : null, (JoinableFactoryWrapper)dataSource.getJoinableFactoryWrapper());
            inputSpecs.addAll(clausePlan.getInputSpecs());
            clausePlan.getBroadcastInputs().intStream().forEach(arg_0 -> DataSourcePlan.lambda$forJoin$0((IntSet)broadcastInputs, shift, arg_0));
            clausePlan.getSubQueryDefBuilder().ifPresent(subQueryDefBuilder::addAll);
        }
        return new DataSourcePlan(newDataSource, inputSpecs, (IntSet)broadcastInputs, subQueryDefBuilder);
    }

    private static DataSource shiftInputNumbers(DataSource dataSource, int shift) {
        if (shift < 0) {
            throw new IAE("Shift must be >= 0", new Object[0]);
        }
        if (shift == 0) {
            return dataSource;
        }
        if (dataSource instanceof InputNumberDataSource) {
            return new InputNumberDataSource(((InputNumberDataSource)dataSource).getInputNumber() + shift);
        }
        return dataSource.withChildren(dataSource.getChildren().stream().map(child -> DataSourcePlan.shiftInputNumbers(child, shift)).collect(Collectors.toList()));
    }

    private static List<Interval> querySegmentSpecIntervals(QuerySegmentSpec querySegmentSpec) {
        if (querySegmentSpec instanceof MultipleIntervalSegmentSpec) {
            return querySegmentSpec.getIntervals();
        }
        throw new UOE("Cannot handle querySegmentSpec type [%s]", new Object[]{querySegmentSpec.getClass().getName()});
    }

    private static void checkQuerySegmentSpecIsEternity(DataSource dataSource, QuerySegmentSpec querySegmentSpec) {
        boolean querySegmentSpecIsEternity;
        boolean bl = querySegmentSpecIsEternity = querySegmentSpec instanceof MultipleIntervalSegmentSpec && querySegmentSpec.getIntervals().equals(Intervals.ONLY_ETERNITY);
        if (!querySegmentSpecIsEternity) {
            throw new UOE("Cannot filter datasource [%s] using [%s]", new Object[]{dataSource.getClass().getName(), "__time"});
        }
    }

    private static /* synthetic */ void lambda$forJoin$0(IntSet broadcastInputs, int shift, int n) {
        broadcastInputs.add(n + shift);
    }

    static {
        CONTEXT_MAP_NO_SEGMENT_GRANULARITY.put("sqlInsertSegmentGranularity", null);
    }
}

