/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.msq.indexing.error.BroadcastTablesTooLargeFault;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.querykit.InputNumberDataSource;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.join.JoinableFactoryWrapper;

public class BroadcastJoinHelper {
    private final Int2IntMap inputNumberToProcessorChannelMap;
    private final List<ReadableFrameChannel> channels;
    private final List<FrameReader> channelReaders;
    private final JoinableFactoryWrapper joinableFactory;
    private final List<List<Object[]>> channelData;
    private final IntSet sideChannelNumbers;
    private final long memoryReservedForBroadcastJoin;
    private long memoryUsed = 0L;

    public BroadcastJoinHelper(Int2IntMap inputNumberToProcessorChannelMap, List<ReadableFrameChannel> channels, List<FrameReader> channelReaders, JoinableFactoryWrapper joinableFactory, long memoryReservedForBroadcastJoin) {
        this.inputNumberToProcessorChannelMap = inputNumberToProcessorChannelMap;
        this.channels = channels;
        this.channelReaders = channelReaders;
        this.joinableFactory = joinableFactory;
        this.channelData = new ArrayList<List<Object[]>>();
        this.sideChannelNumbers = new IntOpenHashSet();
        this.sideChannelNumbers.addAll(inputNumberToProcessorChannelMap.values());
        this.memoryReservedForBroadcastJoin = memoryReservedForBroadcastJoin;
        for (int i = 0; i < channels.size(); ++i) {
            if (this.sideChannelNumbers.contains(i)) {
                this.channelData.add(new ArrayList());
                this.sideChannelNumbers.add(i);
                continue;
            }
            this.channelData.add(null);
        }
    }

    public boolean buildBroadcastTablesIncrementally(IntSet readableInputs) {
        IntIterator inputChannelIterator = readableInputs.iterator();
        while (inputChannelIterator.hasNext()) {
            int channelNumber = inputChannelIterator.nextInt();
            if (!this.sideChannelNumbers.contains(channelNumber) || !this.channels.get(channelNumber).canRead()) continue;
            Frame frame = this.channels.get(channelNumber).read();
            this.memoryUsed += frame.numBytes();
            if (this.memoryUsed > this.memoryReservedForBroadcastJoin) {
                throw new MSQException(new BroadcastTablesTooLargeFault(this.memoryReservedForBroadcastJoin));
            }
            this.addFrame(channelNumber, frame);
        }
        IntIterator intIterator = this.sideChannelNumbers.iterator();
        while (intIterator.hasNext()) {
            int channelNumber = (Integer)intIterator.next();
            if (this.channels.get(channelNumber).isFinished()) continue;
            return false;
        }
        return true;
    }

    public IntSet getSideChannelNumbers() {
        return this.sideChannelNumbers;
    }

    public DataSource inlineChannelData(DataSource originalDataSource) {
        if (originalDataSource instanceof InputNumberDataSource) {
            int inputNumber = ((InputNumberDataSource)originalDataSource).getInputNumber();
            if (this.inputNumberToProcessorChannelMap.containsKey(inputNumber)) {
                int channelNumber = this.inputNumberToProcessorChannelMap.get(inputNumber);
                if (this.sideChannelNumbers.contains(channelNumber)) {
                    return InlineDataSource.fromIterable((Iterable)this.channelData.get(channelNumber), (RowSignature)this.channelReaders.get(channelNumber).signature());
                }
                return originalDataSource;
            }
            return originalDataSource;
        }
        ArrayList<DataSource> newChildren = new ArrayList<DataSource>(originalDataSource.getChildren().size());
        for (DataSource child : originalDataSource.getChildren()) {
            newChildren.add(this.inlineChannelData(child));
        }
        return originalDataSource.withChildren(newChildren);
    }

    private void addFrame(int channelNumber, Frame frame) {
        List<Object[]> data = this.channelData.get(channelNumber);
        FrameReader frameReader = this.channelReaders.get(channelNumber);
        Cursor cursor = FrameProcessors.makeCursor((Frame)frame, (FrameReader)frameReader);
        List selectors = frameReader.signature().getColumnNames().stream().map(columnName -> cursor.getColumnSelectorFactory().makeColumnValueSelector(columnName)).collect(Collectors.toList());
        while (!cursor.isDone()) {
            Object[] row = new Object[selectors.size()];
            for (int i = 0; i < row.length; ++i) {
                row[i] = ((ColumnValueSelector)selectors.get(i)).getObject();
            }
            data.add(row);
            cursor.advance();
        }
    }
}

