/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.ReadableConcatFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.OutputChannel;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.OutputChannels;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.InputSlices;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.ReadableInputs;
import org.apache.druid.msq.input.external.ExternalInputSlice;
import org.apache.druid.msq.input.stage.StageInputSlice;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.kernel.ProcessorsAndChannels;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.querykit.BaseFrameProcessorFactory;
import org.apache.druid.msq.querykit.LazyResourceHolder;
import org.apache.druid.segment.column.RowSignature;

public abstract class BaseLeafFrameProcessorFactory
extends BaseFrameProcessorFactory {
    private static final Logger log = new Logger(BaseLeafFrameProcessorFactory.class);

    @Override
    public ProcessorsAndChannels<FrameProcessor<Long>, Long> makeProcessors(StageDefinition stageDefinition, int workerNumber, List<InputSlice> inputSlices, InputSliceReader inputSliceReader, @Nullable Object extra, OutputChannelFactory outputChannelFactory, FrameContext frameContext, int maxOutstandingProcessors, CounterTracker counters, Consumer<Throwable> warningPublisher) throws IOException {
        int totalProcessors = InputSlices.getNumNonBroadcastReadableInputs(inputSlices, inputSliceReader, stageDefinition.getBroadcastInputNumbers());
        if (totalProcessors == 0) {
            return new ProcessorsAndChannels<FrameProcessor<Long>, Long>(Sequences.empty(), OutputChannels.none());
        }
        int outstandingProcessors = BaseLeafFrameProcessorFactory.hasParquet(inputSlices) ? 1 : Math.min(totalProcessors, maxOutstandingProcessors);
        AtomicReference allocatorQueueRef = new AtomicReference(new ArrayDeque(outstandingProcessors));
        AtomicReference channelQueueRef = new AtomicReference(new ArrayDeque(outstandingProcessors));
        ArrayList<OutputChannel> outputChannels = new ArrayList<OutputChannel>(outstandingProcessors);
        for (int i = 0; i < outstandingProcessors; ++i) {
            OutputChannel outputChannel = outputChannelFactory.openChannel(0);
            outputChannels.add(outputChannel);
            ((Queue)channelQueueRef.get()).add(outputChannel.getWritableChannel());
            ((Queue)allocatorQueueRef.get()).add(outputChannel.getFrameMemoryAllocator());
        }
        Sequence<ReadableInput> processorBaseInputs = BaseLeafFrameProcessorFactory.readBaseInputs(stageDefinition, inputSlices, inputSliceReader, counters, warningPublisher);
        Sequence processors = processorBaseInputs.map(processorBaseInput -> {
            Int2ObjectMap<ReadableInput> sideChannels = BaseLeafFrameProcessorFactory.readBroadcastInputs(stageDefinition, inputSlices, inputSliceReader, counters, warningPublisher);
            return this.makeProcessor((ReadableInput)processorBaseInput, sideChannels, BaseLeafFrameProcessorFactory.makeLazyResourceHolder(channelQueueRef, channel -> {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }), BaseLeafFrameProcessorFactory.makeLazyResourceHolder(allocatorQueueRef, ignored -> {}), stageDefinition.getSignature(), stageDefinition.getClusterBy(), frameContext);
        }).withBaggage(() -> {
            WritableFrameChannel c;
            Queue channelQueue;
            AtomicReference atomicReference = channelQueueRef;
            synchronized (atomicReference) {
                channelQueue = channelQueueRef.getAndSet(null);
            }
            while ((c = (WritableFrameChannel)channelQueue.poll()) != null) {
                try {
                    c.close();
                }
                catch (Throwable e) {
                    log.warn(e, "Error encountered while closing channel for [%s]", new Object[]{this});
                }
            }
        });
        return new ProcessorsAndChannels<FrameProcessor<Long>, Long>(processors, OutputChannels.wrapReadOnly(outputChannels));
    }

    private static Sequence<ReadableInput> readBaseInputs(StageDefinition stageDef, List<InputSlice> inputSlices, InputSliceReader inputSliceReader, CounterTracker counters, Consumer<Throwable> warningPublisher) {
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        for (int inputNumber = 0; inputNumber < inputSlices.size(); ++inputNumber) {
            if (stageDef.getBroadcastInputNumbers().contains(inputNumber)) continue;
            int i = inputNumber;
            Sequence sequence = Sequences.simple((Iterable)inputSliceReader.attach(i, inputSlices.get(i), counters, warningPublisher));
            sequences.add(sequence);
        }
        return Sequences.concat(sequences);
    }

    private static Int2ObjectMap<ReadableInput> readBroadcastInputs(StageDefinition stageDef, List<InputSlice> inputSlices, InputSliceReader inputSliceReader, CounterTracker counterTracker, Consumer<Throwable> warningPublisher) {
        Int2ObjectAVLTreeMap broadcastInputs = new Int2ObjectAVLTreeMap();
        try {
            for (int inputNumber = 0; inputNumber < inputSlices.size(); ++inputNumber) {
                if (!stageDef.getBroadcastInputNumbers().contains(inputNumber)) continue;
                StageInputSlice slice = (StageInputSlice)inputSlices.get(inputNumber);
                ReadableInputs readableInputs = inputSliceReader.attach(inputNumber, slice, counterTracker, warningPublisher);
                if (!readableInputs.isChannelBased()) {
                    throw new ISE("Broadcast inputs must be channels", new Object[0]);
                }
                ReadableConcatFrameChannel channel = ReadableConcatFrameChannel.open((Iterator)Iterators.transform(readableInputs.iterator(), ReadableInput::getChannel));
                broadcastInputs.put(inputNumber, (Object)ReadableInput.channel((ReadableFrameChannel)channel, readableInputs.frameReader(), null));
            }
            return broadcastInputs;
        }
        catch (Throwable e) {
            try {
                broadcastInputs.values().forEach(input -> input.getChannel().close());
            }
            catch (Throwable e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
    }

    protected abstract FrameProcessor<Long> makeProcessor(ReadableInput var1, Int2ObjectMap<ReadableInput> var2, ResourceHolder<WritableFrameChannel> var3, ResourceHolder<MemoryAllocator> var4, RowSignature var5, ClusterBy var6, FrameContext var7);

    private static <T> ResourceHolder<T> makeLazyResourceHolder(AtomicReference<Queue<T>> queueRef, Consumer<T> backupCloser) {
        return new LazyResourceHolder(() -> {
            Object resource;
            AtomicReference atomicReference = queueRef;
            synchronized (atomicReference) {
                resource = ((Queue)queueRef.get()).poll();
            }
            return Pair.of(resource, () -> {
                AtomicReference atomicReference = queueRef;
                synchronized (atomicReference) {
                    Queue queue = (Queue)queueRef.get();
                    if (queue != null) {
                        queue.add(resource);
                        return;
                    }
                }
                backupCloser.accept(resource);
            });
        });
    }

    private static boolean hasParquet(List<InputSlice> slices) {
        return slices.stream().anyMatch(slice -> slice instanceof ExternalInputSlice && ((ExternalInputSlice)slice).getInputFormat().getClass().getName().contains("Parquet"));
    }
}

