/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.querykit;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.table.SegmentWithDescriptor;
import org.apache.druid.msq.querykit.BroadcastJoinHelper;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.JoinDataSource;
import org.apache.druid.query.Query;
import org.apache.druid.segment.ReferenceCountingSegment;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.join.JoinableFactoryWrapper;

public abstract class BaseLeafFrameProcessor
implements FrameProcessor<Long> {
    private final Query<?> query;
    private final ReadableInput baseInput;
    private final List<ReadableFrameChannel> inputChannels;
    private final ResourceHolder<WritableFrameChannel> outputChannel;
    private final ResourceHolder<FrameWriterFactory> frameWriterFactoryHolder;
    private final BroadcastJoinHelper broadcastJoinHelper;
    private Function<SegmentReference, SegmentReference> segmentMapFn;

    protected BaseLeafFrameProcessor(Query<?> query, ReadableInput baseInput, Int2ObjectMap<ReadableInput> sideChannels, JoinableFactoryWrapper joinableFactory, ResourceHolder<WritableFrameChannel> outputChannel, ResourceHolder<FrameWriterFactory> frameWriterFactoryHolder, long memoryReservedForBroadcastJoin) {
        this.query = query;
        this.baseInput = baseInput;
        this.outputChannel = outputChannel;
        this.frameWriterFactoryHolder = frameWriterFactoryHolder;
        Pair<List<ReadableFrameChannel>, BroadcastJoinHelper> inputChannelsAndBroadcastJoinHelper = BaseLeafFrameProcessor.makeInputChannelsAndBroadcastJoinHelper(query.getDataSource(), baseInput, sideChannels, joinableFactory, memoryReservedForBroadcastJoin);
        this.inputChannels = (List)inputChannelsAndBroadcastJoinHelper.lhs;
        this.broadcastJoinHelper = (BroadcastJoinHelper)inputChannelsAndBroadcastJoinHelper.rhs;
    }

    private static Pair<List<ReadableFrameChannel>, BroadcastJoinHelper> makeInputChannelsAndBroadcastJoinHelper(DataSource dataSource, ReadableInput baseInput, Int2ObjectMap<ReadableInput> sideChannels, JoinableFactoryWrapper joinableFactory, long memoryReservedForBroadcastJoin) {
        BroadcastJoinHelper broadcastJoinHelper;
        if (!(dataSource instanceof JoinDataSource) && !sideChannels.isEmpty()) {
            throw new ISE("Did not expect side channels for dataSource [%s]", new Object[]{dataSource});
        }
        ArrayList<ReadableFrameChannel> inputChannels = new ArrayList<ReadableFrameChannel>();
        if (baseInput.hasChannel()) {
            inputChannels.add(baseInput.getChannel());
        }
        if (dataSource instanceof JoinDataSource) {
            Int2IntOpenHashMap inputNumberToProcessorChannelMap = new Int2IntOpenHashMap();
            ArrayList<FrameReader> channelReaders = new ArrayList<FrameReader>();
            if (baseInput.hasChannel()) {
                channelReaders.add(null);
            }
            for (Int2ObjectMap.Entry sideChannelEntry : sideChannels.int2ObjectEntrySet()) {
                int inputNumber = sideChannelEntry.getIntKey();
                inputNumberToProcessorChannelMap.put(inputNumber, inputChannels.size());
                inputChannels.add(((ReadableInput)sideChannelEntry.getValue()).getChannel());
                channelReaders.add(((ReadableInput)sideChannelEntry.getValue()).getChannelFrameReader());
            }
            broadcastJoinHelper = new BroadcastJoinHelper((Int2IntMap)inputNumberToProcessorChannelMap, inputChannels, channelReaders, joinableFactory, memoryReservedForBroadcastJoin);
        } else {
            broadcastJoinHelper = null;
        }
        return Pair.of(inputChannels, broadcastJoinHelper);
    }

    public List<ReadableFrameChannel> inputChannels() {
        return this.inputChannels;
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.singletonList(this.outputChannel.get());
    }

    public ReturnOrAwait<Long> runIncrementally(IntSet readableInputs) throws IOException {
        if (!this.initializeSegmentMapFn(readableInputs)) {
            return ReturnOrAwait.awaitAll((IntSet)this.broadcastJoinHelper.getSideChannelNumbers());
        }
        if (readableInputs.size() != this.inputChannels.size()) {
            return ReturnOrAwait.awaitAll((int)this.inputChannels.size());
        }
        if (this.baseInput.hasSegment()) {
            return this.runWithSegment(this.baseInput.getSegment());
        }
        assert (this.baseInput.hasChannel());
        return this.runWithInputChannel(this.baseInput.getChannel(), this.baseInput.getChannelFrameReader());
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), Collections.emptyList(), (Closeable[])new Closeable[]{this.outputChannel, this.frameWriterFactoryHolder});
    }

    protected FrameWriterFactory getFrameWriterFactory() {
        return (FrameWriterFactory)this.frameWriterFactoryHolder.get();
    }

    protected abstract ReturnOrAwait<Long> runWithSegment(SegmentWithDescriptor var1) throws IOException;

    protected abstract ReturnOrAwait<Long> runWithInputChannel(ReadableFrameChannel var1, FrameReader var2) throws IOException;

    protected SegmentReference mapSegment(Segment segment) {
        return this.segmentMapFn.apply((SegmentReference)ReferenceCountingSegment.wrapRootGenerationSegment((Segment)segment));
    }

    private boolean initializeSegmentMapFn(IntSet readableInputs) {
        AtomicLong cpuAccumulator = new AtomicLong();
        if (this.segmentMapFn != null) {
            return true;
        }
        if (this.broadcastJoinHelper == null) {
            this.segmentMapFn = Function.identity();
            return true;
        }
        boolean retVal = this.broadcastJoinHelper.buildBroadcastTablesIncrementally(readableInputs);
        DataSource inlineChannelDataSource = this.broadcastJoinHelper.inlineChannelData(this.query.getDataSource());
        if (retVal) {
            this.segmentMapFn = inlineChannelDataSource.createSegmentMapFunction(this.query, cpuAccumulator);
        }
        return retVal;
    }
}

