/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel.worker;

import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.kernel.worker.WorkerStagePhase;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;

public class WorkerStageKernel {
    private final WorkOrder workOrder;
    private WorkerStagePhase phase = WorkerStagePhase.NEW;
    @Nullable
    private volatile ClusterByStatisticsSnapshot resultKeyStatisticsSnapshot;
    @Nullable
    private ClusterByPartitions resultPartitionBoundaries;
    @Nullable
    private Object resultObject;
    @Nullable
    private Throwable exceptionFromFail;
    private final Set<Pair<StageId, Integer>> postedResultsComplete = new HashSet<Pair<StageId, Integer>>();

    private WorkerStageKernel(WorkOrder workOrder) {
        this.workOrder = workOrder;
        if (workOrder.getStageDefinition().doesShuffle() && !workOrder.getStageDefinition().mustGatherResultKeyStatistics()) {
            this.resultPartitionBoundaries = (ClusterByPartitions)workOrder.getStageDefinition().generatePartitionsForShuffle(null).valueOrThrow();
        }
    }

    public static WorkerStageKernel create(WorkOrder workOrder) {
        return new WorkerStageKernel(workOrder);
    }

    public WorkerStagePhase getPhase() {
        return this.phase;
    }

    public WorkOrder getWorkOrder() {
        return this.workOrder;
    }

    public StageDefinition getStageDefinition() {
        return this.workOrder.getStageDefinition();
    }

    public void startReading() {
        this.transitionTo(WorkerStagePhase.READING_INPUT);
    }

    public void startPreshuffleWaitingForResultPartitionBoundaries() {
        this.assertPreshuffleStatisticsNeeded();
        this.transitionTo(WorkerStagePhase.PRESHUFFLE_WAITING_FOR_RESULT_PARTITION_BOUNDARIES);
    }

    public void startPreshuffleWritingOutput() {
        this.assertPreshuffleStatisticsNeeded();
        this.transitionTo(WorkerStagePhase.PRESHUFFLE_WRITING_OUTPUT);
    }

    public void setResultKeyStatisticsSnapshot(ClusterByStatisticsSnapshot resultKeyStatisticsSnapshot) {
        this.assertPreshuffleStatisticsNeeded();
        this.resultKeyStatisticsSnapshot = resultKeyStatisticsSnapshot;
    }

    public void setResultPartitionBoundaries(ClusterByPartitions resultPartitionBoundaries) {
        this.assertPreshuffleStatisticsNeeded();
        this.resultPartitionBoundaries = resultPartitionBoundaries;
    }

    public boolean hasResultKeyStatisticsSnapshot() {
        return this.resultKeyStatisticsSnapshot != null;
    }

    public boolean hasResultPartitionBoundaries() {
        return this.resultPartitionBoundaries != null;
    }

    public ClusterByStatisticsSnapshot getResultKeyStatisticsSnapshot() {
        return (ClusterByStatisticsSnapshot)Preconditions.checkNotNull((Object)this.resultKeyStatisticsSnapshot, (Object)"resultKeyStatisticsSnapshot");
    }

    public ClusterByPartitions getResultPartitionBoundaries() {
        return (ClusterByPartitions)Preconditions.checkNotNull((Object)this.resultPartitionBoundaries, (Object)"resultPartitionBoundaries");
    }

    @Nullable
    public Object getResultObject() {
        if (this.phase == WorkerStagePhase.RESULTS_READY || this.phase == WorkerStagePhase.FINISHED) {
            return this.resultObject;
        }
        throw new ISE("Results are not ready yet", new Object[0]);
    }

    public Throwable getException() {
        if (this.phase == WorkerStagePhase.FAILED) {
            return this.exceptionFromFail;
        }
        throw new ISE("Stage has not failed", new Object[0]);
    }

    public void setResultsComplete(Object resultObject) {
        if (resultObject == null) {
            throw new NullPointerException("resultObject must not be null");
        }
        this.transitionTo(WorkerStagePhase.RESULTS_READY);
        this.resultObject = resultObject;
    }

    public void setStageFinished() {
        this.transitionTo(WorkerStagePhase.FINISHED);
    }

    public void fail(Throwable t) {
        Preconditions.checkNotNull((Object)t, (Object)"t");
        this.transitionTo(WorkerStagePhase.FAILED);
        this.resultKeyStatisticsSnapshot = null;
        this.resultPartitionBoundaries = null;
        if (this.exceptionFromFail == null) {
            this.exceptionFromFail = t;
        }
    }

    public boolean addPostedResultsComplete(Pair<StageId, Integer> stageIdAndWorkerNumber) {
        return this.postedResultsComplete.add(stageIdAndWorkerNumber);
    }

    private void assertPreshuffleStatisticsNeeded() {
        if (!this.workOrder.getStageDefinition().mustGatherResultKeyStatistics()) {
            throw new ISE("Result partitioning is not necessary for stage [%s]", new Object[]{this.workOrder.getStageDefinition().getId()});
        }
    }

    private void transitionTo(WorkerStagePhase newPhase) {
        if (!newPhase.canTransitionFrom(this.phase)) {
            throw new IAE("Cannot transition from [%s] to [%s]", new Object[]{this.phase, newPhase});
        }
        this.phase = newPhase;
    }
}

