/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel.controller;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.input.NilInputSlice;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.WorkerAssignmentStrategy;

public class WorkerInputs {
    private final Int2ObjectMap<List<InputSlice>> assignmentsMap;

    private WorkerInputs(Int2ObjectMap<List<InputSlice>> assignmentsMap) {
        this.assignmentsMap = assignmentsMap;
    }

    public static WorkerInputs create(StageDefinition stageDef, Int2IntMap stageWorkerCountMap, InputSpecSlicer slicer, WorkerAssignmentStrategy assignmentStrategy) {
        Int2ObjectAVLTreeMap assignmentsMap = new Int2ObjectAVLTreeMap();
        int numInputs = stageDef.getInputSpecs().size();
        if (numInputs == 0) {
            assignmentsMap.put(0, Collections.singletonList(NilInputSlice.INSTANCE));
            return new WorkerInputs((Int2ObjectMap<List<InputSlice>>)assignmentsMap);
        }
        for (int inputNumber = 0; inputNumber < numInputs; ++inputNumber) {
            InputSpec inputSpec = stageDef.getInputSpecs().get(inputNumber);
            if (stageDef.getBroadcastInputNumbers().contains(inputNumber)) {
                List<InputSlice> broadcastSlices = slicer.sliceStatic(inputSpec, 1);
                NilInputSlice broadcastSlice = broadcastSlices.isEmpty() ? NilInputSlice.INSTANCE : (InputSlice)Iterables.getOnlyElement(broadcastSlices);
                for (int workerNumber = 0; workerNumber < stageDef.getMaxWorkerCount(); ++workerNumber) {
                    ((List)assignmentsMap.computeIfAbsent(workerNumber, ignored -> Arrays.asList(new InputSlice[numInputs]))).set(inputNumber, broadcastSlice);
                }
                continue;
            }
            List<InputSlice> slices = assignmentStrategy.assign(stageDef, inputSpec, stageWorkerCountMap, slicer);
            for (int workerNumber = 0; workerNumber < slices.size(); ++workerNumber) {
                ((List)assignmentsMap.computeIfAbsent(workerNumber, ignored -> Arrays.asList(new InputSlice[numInputs]))).set(inputNumber, slices.get(workerNumber));
            }
        }
        ObjectIterator assignmentsIterator = assignmentsMap.int2ObjectEntrySet().iterator();
        boolean first = true;
        while (assignmentsIterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)assignmentsIterator.next();
            List slices = (List)entry.getValue();
            for (int inputNumber = 0; inputNumber < numInputs; ++inputNumber) {
                if (slices.get(inputNumber) != null) continue;
                slices.set(inputNumber, NilInputSlice.INSTANCE);
            }
            boolean hasNonNilNonBroadcastInput = IntStream.range(0, numInputs).anyMatch(i -> !((InputSlice)slices.get(i)).equals(NilInputSlice.INSTANCE) && !stageDef.getBroadcastInputNumbers().contains(i));
            if (!first && !hasNonNilNonBroadcastInput) {
                assignmentsIterator.remove();
            }
            first = false;
        }
        return new WorkerInputs((Int2ObjectMap<List<InputSlice>>)assignmentsMap);
    }

    public List<InputSlice> inputsForWorker(int workerNumber) {
        return (List)Preconditions.checkNotNull((Object)this.assignmentsMap.get(workerNumber), (String)"worker [%s]", (Object[])new Object[]{workerNumber});
    }

    public IntSet workers() {
        return this.assignmentsMap.keySet();
    }

    public int workerCount() {
        return this.assignmentsMap.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkerInputs that = (WorkerInputs)o;
        return Objects.equals(this.assignmentsMap, that.assignmentsMap);
    }

    public int hashCode() {
        return Objects.hash(this.assignmentsMap);
    }

    public String toString() {
        return this.assignmentsMap.toString();
    }
}

