/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel.controller;

import it.unimi.dsi.fastutil.ints.Int2IntAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.indexing.error.InsertTimeNullFault;
import org.apache.druid.msq.indexing.error.MSQFault;
import org.apache.druid.msq.indexing.error.TooManyPartitionsFault;
import org.apache.druid.msq.indexing.error.UnknownFault;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.input.stage.ReadablePartition;
import org.apache.druid.msq.input.stage.ReadablePartitions;
import org.apache.druid.msq.input.stage.StageInputSlice;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.WorkerAssignmentStrategy;
import org.apache.druid.msq.kernel.controller.ControllerStagePhase;
import org.apache.druid.msq.kernel.controller.WorkerInputs;
import org.apache.druid.msq.statistics.CompleteKeyStatisticsInformation;
import org.apache.druid.msq.statistics.PartialKeyStatisticsInformation;

class ControllerStageTracker {
    private final StageDefinition stageDef;
    private final int workerCount;
    private final WorkerInputs workerInputs;
    private final IntSet workersWithReportedKeyStatistics = new IntAVLTreeSet();
    private final IntSet workersWithResultsComplete = new IntAVLTreeSet();
    private ControllerStagePhase phase = ControllerStagePhase.NEW;
    @Nullable
    public final CompleteKeyStatisticsInformation completeKeyStatisticsInformation;
    @Nullable
    private ReadablePartitions resultPartitions;
    @Nullable
    private ClusterByPartitions resultPartitionBoundaries;
    @Nullable
    private Object resultObject;
    @Nullable
    private MSQFault failureReason;

    private ControllerStageTracker(StageDefinition stageDef, WorkerInputs workerInputs) {
        this.stageDef = stageDef;
        this.workerCount = workerInputs.workerCount();
        this.workerInputs = workerInputs;
        if (stageDef.mustGatherResultKeyStatistics()) {
            this.completeKeyStatisticsInformation = new CompleteKeyStatisticsInformation(new TreeMap<Long, Set<Integer>>(), false, 0.0);
        } else {
            this.completeKeyStatisticsInformation = null;
            this.generateResultPartitionsAndBoundariesWithoutKeyStatistics();
        }
    }

    static ControllerStageTracker create(StageDefinition stageDef, Int2IntMap stageWorkerCountMap, InputSpecSlicer slicer, WorkerAssignmentStrategy assignmentStrategy) {
        WorkerInputs workerInputs = WorkerInputs.create(stageDef, stageWorkerCountMap, slicer, assignmentStrategy);
        return new ControllerStageTracker(stageDef, workerInputs);
    }

    StageDefinition getStageDefinition() {
        return this.stageDef;
    }

    ControllerStagePhase getPhase() {
        return this.phase;
    }

    boolean hasResultPartitions() {
        return this.resultPartitions != null;
    }

    ReadablePartitions getResultPartitions() {
        if (this.resultPartitions == null) {
            throw new ISE("Result partition information is not ready yet", new Object[0]);
        }
        return this.resultPartitions;
    }

    ClusterByPartitions getResultPartitionBoundaries() {
        if (!this.getStageDefinition().doesShuffle()) {
            throw new ISE("Result partition information is not relevant to this stage because it does not shuffle", new Object[0]);
        }
        if (this.resultPartitionBoundaries == null) {
            throw new ISE("Result partition information is not ready yet", new Object[0]);
        }
        return this.resultPartitionBoundaries;
    }

    boolean collectorEncounteredAnyMultiValueField() {
        if (this.completeKeyStatisticsInformation == null) {
            throw new ISE("Stage does not gather result key statistics", new Object[0]);
        }
        if (this.workersWithReportedKeyStatistics.size() != this.workerCount) {
            throw new ISE("Result key statistics are not ready", new Object[0]);
        }
        return this.completeKeyStatisticsInformation.hasMultipleValues();
    }

    Object getResultObject() {
        if (this.phase == ControllerStagePhase.FINISHED) {
            throw new ISE("Result object has been cleaned up prematurely", new Object[0]);
        }
        if (this.phase != ControllerStagePhase.RESULTS_READY) {
            throw new ISE("Result object is not ready yet", new Object[0]);
        }
        if (this.resultObject == null) {
            throw new NullPointerException("resultObject was unexpectedly null");
        }
        return this.resultObject;
    }

    void start() {
        this.transitionTo(ControllerStagePhase.READING_INPUT);
    }

    void finish() {
        this.transitionTo(ControllerStagePhase.FINISHED);
    }

    WorkerInputs getWorkerInputs() {
        return this.workerInputs;
    }

    @Nullable
    public CompleteKeyStatisticsInformation getCompleteKeyStatisticsInformation() {
        return this.completeKeyStatisticsInformation;
    }

    ControllerStagePhase addPartialKeyStatisticsForWorker(int workerNumber, PartialKeyStatisticsInformation partialKeyStatisticsInformation) {
        if (this.phase != ControllerStagePhase.READING_INPUT) {
            throw new ISE("Cannot add result key statistics from stage [%s]", new Object[]{this.phase});
        }
        if (!this.stageDef.mustGatherResultKeyStatistics() || !this.stageDef.doesShuffle() || this.completeKeyStatisticsInformation == null) {
            throw new ISE("Stage does not gather result key statistics", new Object[0]);
        }
        if (workerNumber < 0 || workerNumber >= this.workerCount) {
            throw new IAE("Invalid workerNumber [%s]", new Object[]{workerNumber});
        }
        try {
            if (this.workersWithReportedKeyStatistics.add(workerNumber)) {
                if (partialKeyStatisticsInformation.getTimeSegments().contains(null)) {
                    this.failForReason(InsertTimeNullFault.instance());
                    return this.getPhase();
                }
                this.completeKeyStatisticsInformation.mergePartialInformation(workerNumber, partialKeyStatisticsInformation);
                if (this.workersWithReportedKeyStatistics.size() == this.workerCount) {
                    this.transitionTo(ControllerStagePhase.MERGING_STATISTICS);
                }
            }
        }
        catch (Exception e) {
            this.fail();
            throw e;
        }
        return this.getPhase();
    }

    void setClusterByPartitionBoundaries(ClusterByPartitions clusterByPartitions) {
        if (this.resultPartitions != null) {
            throw new ISE("Result partitions have already been generated", new Object[0]);
        }
        if (!this.stageDef.mustGatherResultKeyStatistics()) {
            throw new ISE("Result partitions does not require key statistics, should not have set partition boundries here", new Object[0]);
        }
        if (!ControllerStagePhase.MERGING_STATISTICS.equals((Object)this.getPhase())) {
            throw new ISE("Cannot set partition boundires from key statistics from stage [%s]", new Object[]{this.getPhase()});
        }
        this.resultPartitionBoundaries = clusterByPartitions;
        this.resultPartitions = ReadablePartitions.striped(this.stageDef.getStageNumber(), this.workerCount, clusterByPartitions.size());
        this.transitionTo(ControllerStagePhase.POST_READING);
    }

    boolean setResultsCompleteForWorker(int workerNumber, Object resultObject) {
        if (workerNumber < 0 || workerNumber >= this.workerCount) {
            throw new IAE("Invalid workerNumber [%s]", new Object[]{workerNumber});
        }
        if (resultObject == null) {
            throw new NullPointerException("resultObject must not be null");
        }
        if (this.workersWithResultsComplete.add(workerNumber)) {
            this.resultObject = this.resultObject == null ? resultObject : this.getStageDefinition().getProcessorFactory().mergeAccumulatedResult(this.resultObject, resultObject);
        }
        if (this.workersWithResultsComplete.size() == this.workerCount) {
            this.transitionTo(ControllerStagePhase.RESULTS_READY);
            return true;
        }
        return false;
    }

    MSQFault getFailureReason() {
        if (this.phase != ControllerStagePhase.FAILED) {
            throw new ISE("No failure", new Object[0]);
        }
        return this.failureReason;
    }

    void fail() {
        this.failForReason(UnknownFault.forMessage(null));
    }

    private void generateResultPartitionsAndBoundariesWithoutKeyStatistics() {
        if (this.resultPartitions != null) {
            throw new ISE("Result partitions have already been generated", new Object[0]);
        }
        int stageNumber = this.stageDef.getStageNumber();
        if (this.stageDef.doesShuffle()) {
            if (this.stageDef.mustGatherResultKeyStatistics()) {
                throw new ISE("Cannot generate result partitions without key statistics", new Object[0]);
            }
            Either<Long, ClusterByPartitions> maybeResultPartitionBoundaries = this.stageDef.generatePartitionsForShuffle(null);
            if (maybeResultPartitionBoundaries.isError()) {
                this.failForReason(new TooManyPartitionsFault(this.stageDef.getMaxPartitionCount()));
                return;
            }
            this.resultPartitionBoundaries = (ClusterByPartitions)maybeResultPartitionBoundaries.valueOrThrow();
            this.resultPartitions = ReadablePartitions.striped(stageNumber, this.workerCount, this.resultPartitionBoundaries.size());
        } else {
            Int2IntAVLTreeMap partitionToWorkerMap = new Int2IntAVLTreeMap();
            IntIterator intIterator = this.workerInputs.workers().iterator();
            while (intIterator.hasNext()) {
                int workerNumber = (Integer)intIterator.next();
                List<InputSlice> slices = this.workerInputs.inputsForWorker(workerNumber);
                for (int inputNumber = 0; inputNumber < slices.size(); ++inputNumber) {
                    InputSlice slice = slices.get(inputNumber);
                    if (!(slice instanceof StageInputSlice) || this.stageDef.getBroadcastInputNumbers().contains(inputNumber)) continue;
                    StageInputSlice stageInputSlice = (StageInputSlice)slice;
                    for (ReadablePartition partition : stageInputSlice.getPartitions()) {
                        partitionToWorkerMap.put(partition.getPartitionNumber(), workerNumber);
                    }
                }
            }
            this.resultPartitions = ReadablePartitions.collected(stageNumber, (Map<Integer, Integer>)partitionToWorkerMap);
        }
    }

    void failForReason(MSQFault fault) {
        this.transitionTo(ControllerStagePhase.FAILED);
        this.failureReason = fault;
    }

    void transitionTo(ControllerStagePhase newPhase) {
        if (!newPhase.canTransitionFrom(this.phase)) {
            throw new IAE("Cannot transition from [%s] to [%s]", new Object[]{this.phase, newPhase});
        }
        this.phase = newPhase;
    }
}

