/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel.controller;

import com.google.common.collect.ImmutableSet;
import java.util.Set;

public enum ControllerStagePhase {
    NEW{

        @Override
        public boolean canTransitionFrom(ControllerStagePhase priorPhase) {
            return false;
        }
    }
    ,
    READING_INPUT{

        @Override
        public boolean canTransitionFrom(ControllerStagePhase priorPhase) {
            return priorPhase == NEW;
        }
    }
    ,
    MERGING_STATISTICS{

        @Override
        public boolean canTransitionFrom(ControllerStagePhase priorPhase) {
            return priorPhase == READING_INPUT;
        }
    }
    ,
    POST_READING{

        @Override
        public boolean canTransitionFrom(ControllerStagePhase priorPhase) {
            return priorPhase == MERGING_STATISTICS;
        }
    }
    ,
    RESULTS_READY{

        @Override
        public boolean canTransitionFrom(ControllerStagePhase priorPhase) {
            return priorPhase == READING_INPUT || priorPhase == POST_READING;
        }
    }
    ,
    FINISHED{

        @Override
        public boolean canTransitionFrom(ControllerStagePhase priorPhase) {
            return priorPhase == RESULTS_READY;
        }
    }
    ,
    FAILED{

        @Override
        public boolean canTransitionFrom(ControllerStagePhase priorPhase) {
            return true;
        }
    };

    private static final Set<ControllerStagePhase> TERMINAL_PHASES;
    private static final Set<ControllerStagePhase> POST_READING_PHASES;

    public abstract boolean canTransitionFrom(ControllerStagePhase var1);

    public static boolean isSuccessfulTerminalPhase(ControllerStagePhase phase) {
        return TERMINAL_PHASES.contains((Object)phase);
    }

    public static boolean isPostReadingPhase(ControllerStagePhase phase) {
        return POST_READING_PHASES.contains((Object)phase);
    }

    static {
        TERMINAL_PHASES = ImmutableSet.of((Object)((Object)RESULTS_READY), (Object)((Object)FINISHED));
        POST_READING_PHASES = ImmutableSet.of((Object)((Object)POST_READING), (Object)((Object)RESULTS_READY), (Object)((Object)FINISHED));
    }
}

