/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.IntUnaryOperator;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.kernel.StageDefinition;

public enum WorkerAssignmentStrategy {
    MAX{

        @Override
        public List<InputSlice> assign(StageDefinition stageDef, InputSpec inputSpec, Int2IntMap stageWorkerCountMap, InputSpecSlicer slicer) {
            return slicer.sliceStatic(inputSpec, stageDef.getMaxWorkerCount());
        }
    }
    ,
    AUTO{

        @Override
        public List<InputSlice> assign(StageDefinition stageDef, InputSpec inputSpec, Int2IntMap stageWorkerCountMap, InputSpecSlicer slicer) {
            if (slicer.canSliceDynamic(inputSpec)) {
                return slicer.sliceDynamic(inputSpec, stageDef.getMaxWorkerCount(), 10000, 0x280000000L);
            }
            IntSet inputStages = stageDef.getInputStageNumbers();
            OptionalInt maxInputStageWorkerCount = inputStages.intStream().map((IntUnaryOperator)stageWorkerCountMap).max();
            int workerCount = maxInputStageWorkerCount.orElse(1);
            return slicer.sliceStatic(inputSpec, workerCount);
        }
    };


    @JsonCreator
    public static WorkerAssignmentStrategy fromString(String name) {
        if (name == null) {
            throw new NullPointerException("Null worker assignment strategy");
        }
        return WorkerAssignmentStrategy.valueOf(StringUtils.toUpperCase((String)name));
    }

    @JsonValue
    public String toString() {
        return StringUtils.toLowerCase((String)this.name());
    }

    public abstract List<InputSlice> assign(StageDefinition var1, InputSpec var2, Int2IntMap var3, InputSpecSlicer var4);
}

