/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.kernel.ExtraInfoHolder;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.StageDefinition;

public class WorkOrder {
    private final QueryDefinition queryDefinition;
    private final int stageNumber;
    private final int workerNumber;
    private final List<InputSlice> workerInputs;
    private final ExtraInfoHolder<?> extraInfoHolder;

    @JsonCreator
    public WorkOrder(@JsonProperty(value="query") QueryDefinition queryDefinition, @JsonProperty(value="stage") int stageNumber, @JsonProperty(value="worker") int workerNumber, @JsonProperty(value="input") List<InputSlice> workerInputs, @JsonProperty(value="extra") @Nullable ExtraInfoHolder extraInfoHolder) {
        this.queryDefinition = (QueryDefinition)Preconditions.checkNotNull((Object)queryDefinition, (Object)"queryDefinition");
        this.stageNumber = stageNumber;
        this.workerNumber = workerNumber;
        this.workerInputs = (List)Preconditions.checkNotNull(workerInputs, (Object)"workerInputs");
        this.extraInfoHolder = extraInfoHolder;
    }

    @JsonProperty(value="query")
    public QueryDefinition getQueryDefinition() {
        return this.queryDefinition;
    }

    @JsonProperty(value="stage")
    public int getStageNumber() {
        return this.stageNumber;
    }

    @JsonProperty(value="worker")
    public int getWorkerNumber() {
        return this.workerNumber;
    }

    @JsonProperty(value="input")
    public List<InputSlice> getInputs() {
        return this.workerInputs;
    }

    @Nullable
    @JsonProperty(value="extra")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    ExtraInfoHolder<?> getExtraInfoHolder() {
        return this.extraInfoHolder;
    }

    @Nullable
    public Object getExtraInfo() {
        return this.extraInfoHolder != null ? this.extraInfoHolder.getExtraInfo() : null;
    }

    public StageDefinition getStageDefinition() {
        return this.queryDefinition.getStageDefinition(this.stageNumber);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkOrder workOrder = (WorkOrder)o;
        return this.stageNumber == workOrder.stageNumber && this.workerNumber == workOrder.workerNumber && Objects.equals(this.queryDefinition, workOrder.queryDefinition) && Objects.equals(this.workerInputs, workOrder.workerInputs) && Objects.equals(this.extraInfoHolder, workOrder.extraInfoHolder);
    }

    public int hashCode() {
        return Objects.hash(this.queryDefinition, this.stageNumber, this.workerInputs, this.workerNumber, this.extraInfoHolder);
    }

    public String toString() {
        return "WorkOrder{queryDefinition=" + this.queryDefinition + ", stageNumber=" + this.stageNumber + ", workerNumber=" + this.workerNumber + ", workerInputs=" + this.workerInputs + ", extraInfoHolder=" + this.extraInfoHolder + '}';
    }
}

