/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.msq.kernel.ShuffleSpec;
import org.apache.druid.msq.statistics.ClusterByStatisticsCollector;

public class TargetSizeShuffleSpec
implements ShuffleSpec {
    private final ClusterBy clusterBy;
    private final long targetSize;
    private final boolean aggregate;

    @JsonCreator
    public TargetSizeShuffleSpec(@JsonProperty(value="clusterBy") ClusterBy clusterBy, @JsonProperty(value="targetSize") long targetSize, @JsonProperty(value="aggregate") boolean aggregate) {
        this.clusterBy = (ClusterBy)Preconditions.checkNotNull((Object)clusterBy, (Object)"clusterBy");
        this.targetSize = targetSize;
        this.aggregate = aggregate;
    }

    @Override
    @JsonProperty(value="aggregate")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean doesAggregateByClusterKey() {
        return this.aggregate;
    }

    @Override
    public boolean needsStatistics() {
        return true;
    }

    @Override
    public Either<Long, ClusterByPartitions> generatePartitions(@Nullable ClusterByStatisticsCollector collector, int maxNumPartitions) {
        long expectedPartitions = collector.estimatedTotalWeight() / this.targetSize;
        if (expectedPartitions > (long)maxNumPartitions) {
            return Either.error((Object)expectedPartitions);
        }
        ClusterByPartitions generatedPartitions = collector.generatePartitionsWithTargetWeight(this.targetSize);
        if (generatedPartitions.size() <= maxNumPartitions) {
            return Either.value((Object)generatedPartitions);
        }
        return Either.error((Object)generatedPartitions.size());
    }

    @Override
    @JsonProperty
    public ClusterBy getClusterBy() {
        return this.clusterBy;
    }

    @JsonProperty
    long getTargetSize() {
        return this.targetSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetSizeShuffleSpec that = (TargetSizeShuffleSpec)o;
        return this.targetSize == that.targetSize && this.aggregate == that.aggregate && Objects.equals(this.clusterBy, that.clusterBy);
    }

    public int hashCode() {
        return Objects.hash(this.clusterBy, this.targetSize, this.aggregate);
    }

    public String toString() {
        return "TargetSizeShuffleSpec{clusterBy=" + this.clusterBy + ", targetSize=" + this.targetSize + ", aggregate=" + this.aggregate + '}';
    }
}

