/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel;

import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.kernel.FrameProcessorFactory;
import org.apache.druid.msq.kernel.ShuffleSpec;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.segment.column.RowSignature;

public class StageDefinitionBuilder {
    private final int stageNumber;
    private final List<InputSpec> inputSpecs = new ArrayList<InputSpec>();
    private final IntSet broadcastInputNumbers = new IntRBTreeSet();
    private FrameProcessorFactory processorFactory;
    private RowSignature signature = RowSignature.empty();
    private int maxWorkerCount = 1;
    private ShuffleSpec shuffleSpec = null;
    private boolean shuffleCheckHasMultipleValues = false;

    StageDefinitionBuilder(int stageNumber) {
        this.stageNumber = stageNumber;
    }

    public StageDefinitionBuilder inputs(List<InputSpec> inputSpecs) {
        this.inputSpecs.clear();
        this.inputSpecs.addAll(inputSpecs);
        return this;
    }

    public StageDefinitionBuilder inputs(InputSpec ... inputSpecs) {
        return this.inputs(Arrays.asList(inputSpecs));
    }

    public StageDefinitionBuilder broadcastInputs(IntSet broadcastInputNumbers) {
        this.broadcastInputNumbers.clear();
        IntIterator intIterator = broadcastInputNumbers.iterator();
        while (intIterator.hasNext()) {
            int broadcastInputNumber = (Integer)intIterator.next();
            this.broadcastInputNumbers.add(broadcastInputNumber);
        }
        return this;
    }

    public StageDefinitionBuilder processorFactory(FrameProcessorFactory processorFactory) {
        this.processorFactory = processorFactory;
        return this;
    }

    public StageDefinitionBuilder signature(RowSignature signature) {
        this.signature = signature;
        return this;
    }

    public StageDefinitionBuilder maxWorkerCount(int maxWorkerCount) {
        this.maxWorkerCount = maxWorkerCount;
        return this;
    }

    public StageDefinitionBuilder shuffleCheckHasMultipleValues(boolean shuffleCheckHasMultipleValues) {
        this.shuffleCheckHasMultipleValues = shuffleCheckHasMultipleValues;
        return this;
    }

    public StageDefinitionBuilder shuffleSpec(ShuffleSpec shuffleSpec) {
        this.shuffleSpec = shuffleSpec;
        return this;
    }

    int getStageNumber() {
        return this.stageNumber;
    }

    public StageDefinition build(String queryId) {
        return new StageDefinition(new StageId(queryId, this.stageNumber), this.inputSpecs, (Set<Integer>)this.broadcastInputNumbers, this.processorFactory, this.signature, this.shuffleSpec, this.maxWorkerCount, this.shuffleCheckHasMultipleValues);
    }
}

