/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StageDefinitionBuilder;

public class QueryDefinitionBuilder {
    private String queryId = UUID.randomUUID().toString();
    private final List<StageDefinitionBuilder> stageBuilders = new ArrayList<StageDefinitionBuilder>();

    QueryDefinitionBuilder() {
    }

    public QueryDefinitionBuilder queryId(String queryId) {
        this.queryId = (String)Preconditions.checkNotNull((Object)queryId, (Object)"queryId");
        return this;
    }

    public QueryDefinitionBuilder add(StageDefinitionBuilder stageBuilder) {
        this.stageBuilders.add(stageBuilder);
        return this;
    }

    public QueryDefinitionBuilder addAll(QueryDefinition queryDef) {
        for (StageDefinition stageDef : queryDef.getStageDefinitions()) {
            this.add(StageDefinition.builder(stageDef));
        }
        return this;
    }

    public QueryDefinitionBuilder addAll(QueryDefinitionBuilder queryDefBuilder) {
        for (StageDefinitionBuilder stageDefBuilder : queryDefBuilder.stageBuilders) {
            this.add(stageDefBuilder);
        }
        return this;
    }

    public int getNextStageNumber() {
        return this.stageBuilders.stream().mapToInt(StageDefinitionBuilder::getStageNumber).max().orElse(-1) + 1;
    }

    public QueryDefinition build() {
        List<StageDefinition> stageDefinitions = this.stageBuilders.stream().map(builder -> builder.build(this.queryId)).collect(Collectors.toList());
        return QueryDefinition.create(stageDefinitions);
    }
}

