/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.msq.kernel.ShuffleSpec;
import org.apache.druid.msq.statistics.ClusterByStatisticsCollector;

public class MaxCountShuffleSpec
implements ShuffleSpec {
    private final ClusterBy clusterBy;
    private final int partitions;
    private final boolean aggregate;

    @JsonCreator
    public MaxCountShuffleSpec(@JsonProperty(value="clusterBy") ClusterBy clusterBy, @JsonProperty(value="partitions") int partitions, @JsonProperty(value="aggregate") boolean aggregate) {
        this.clusterBy = (ClusterBy)Preconditions.checkNotNull((Object)clusterBy, (Object)"clusterBy");
        this.partitions = partitions;
        this.aggregate = aggregate;
        if (partitions < 1) {
            throw new IAE("Partition count must be at least 1", new Object[0]);
        }
    }

    @Override
    @JsonProperty(value="aggregate")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean doesAggregateByClusterKey() {
        return this.aggregate;
    }

    @Override
    public boolean needsStatistics() {
        return this.partitions > 1 || this.clusterBy.getBucketByCount() > 0;
    }

    @Override
    public Either<Long, ClusterByPartitions> generatePartitions(@Nullable ClusterByStatisticsCollector collector, int maxNumPartitions) {
        if (!this.needsStatistics()) {
            return Either.value((Object)ClusterByPartitions.oneUniversalPartition());
        }
        if (this.partitions > maxNumPartitions) {
            return Either.error((Object)this.partitions);
        }
        ClusterByPartitions generatedPartitions = collector.generatePartitionsWithMaxCount(this.partitions);
        if (generatedPartitions.size() <= maxNumPartitions) {
            return Either.value((Object)generatedPartitions);
        }
        return Either.error((Object)generatedPartitions.size());
    }

    @Override
    @JsonProperty
    public ClusterBy getClusterBy() {
        return this.clusterBy;
    }

    @JsonProperty
    int getPartitions() {
        return this.partitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaxCountShuffleSpec that = (MaxCountShuffleSpec)o;
        return this.partitions == that.partitions && this.aggregate == that.aggregate && Objects.equals(this.clusterBy, that.clusterBy);
    }

    public int hashCode() {
        return Objects.hash(this.clusterBy, this.partitions, this.aggregate);
    }

    public String toString() {
        return "MaxCountShuffleSpec{clusterBy=" + this.clusterBy + ", partitions=" + this.partitions + ", aggregate=" + this.aggregate + '}';
    }
}

