/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.table;

import com.google.common.base.Preconditions;
import com.google.common.math.LongMath;
import com.google.common.primitives.Ints;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.StreamSupport;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.input.NilInputSlice;
import org.apache.druid.msq.input.SlicerUtils;
import org.apache.druid.msq.input.table.RichSegmentDescriptor;
import org.apache.druid.msq.input.table.SegmentsInputSlice;
import org.apache.druid.msq.input.table.TableInputSpec;
import org.apache.druid.msq.querykit.DataSegmentTimelineView;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DimFilterUtils;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineLookup;
import org.joda.time.Interval;

public class TableInputSpecSlicer
implements InputSpecSlicer {
    private final DataSegmentTimelineView timelineView;

    public TableInputSpecSlicer(DataSegmentTimelineView timelineView) {
        this.timelineView = timelineView;
    }

    @Override
    public boolean canSliceDynamic(InputSpec inputSpec) {
        return true;
    }

    @Override
    public List<InputSlice> sliceStatic(InputSpec inputSpec, int maxNumSlices) {
        TableInputSpec tableInputSpec = (TableInputSpec)inputSpec;
        Set<DataSegmentWithInterval> prunedSegmentSet = this.getPrunedSegmentSet(tableInputSpec);
        return this.makeSlices(tableInputSpec, prunedSegmentSet, maxNumSlices);
    }

    @Override
    public List<InputSlice> sliceDynamic(InputSpec inputSpec, int maxNumSlices, int maxFilesPerSlice, long maxBytesPerSlice) {
        TableInputSpec tableInputSpec = (TableInputSpec)inputSpec;
        Set<DataSegmentWithInterval> prunedSegmentSet = this.getPrunedSegmentSet(tableInputSpec);
        if (prunedSegmentSet.isEmpty()) {
            return Collections.emptyList();
        }
        int totalFiles = 0;
        long totalBytes = 0L;
        for (DataSegmentWithInterval segmentWithInterval : prunedSegmentSet) {
            ++totalFiles;
            totalBytes += segmentWithInterval.getSegment().getSize();
        }
        int numSlices = Math.min(maxNumSlices, Math.max(Ints.checkedCast((long)LongMath.divide((long)totalFiles, (long)maxFilesPerSlice, (RoundingMode)RoundingMode.CEILING)), Ints.checkedCast((long)LongMath.divide((long)totalBytes, (long)maxBytesPerSlice, (RoundingMode)RoundingMode.CEILING))));
        return this.makeSlices(tableInputSpec, prunedSegmentSet, numSlices);
    }

    private Set<DataSegmentWithInterval> getPrunedSegmentSet(TableInputSpec tableInputSpec) {
        TimelineLookup timeline = this.timelineView.getTimeline(tableInputSpec.getDataSource(), tableInputSpec.getIntervals()).orElse(null);
        if (timeline == null) {
            return Collections.emptySet();
        }
        Iterator dataSegmentIterator = tableInputSpec.getIntervals().stream().flatMap(interval -> timeline.lookup(interval).stream()).flatMap(holder -> StreamSupport.stream(holder.getObject().spliterator(), false).map(chunk -> new DataSegmentWithInterval((DataSegment)chunk.getObject(), holder.getInterval()))).iterator();
        return DimFilterUtils.filterShards((DimFilter)tableInputSpec.getFilter(), () -> dataSegmentIterator, segment -> segment.getSegment().getShardSpec());
    }

    private List<InputSlice> makeSlices(TableInputSpec tableInputSpec, Set<DataSegmentWithInterval> prunedSegmentSet, int maxNumSlices) {
        if (prunedSegmentSet.isEmpty()) {
            return Collections.emptyList();
        }
        List<List<DataSegmentWithInterval>> assignments = SlicerUtils.makeSlices(prunedSegmentSet.iterator(), segment -> segment.getSegment().getSize(), maxNumSlices);
        ArrayList<InputSlice> retVal = new ArrayList<InputSlice>();
        for (List<DataSegmentWithInterval> dataSegmentWithIntervals : assignments) {
            ArrayList<RichSegmentDescriptor> descriptors = new ArrayList<RichSegmentDescriptor>();
            for (DataSegmentWithInterval dataSegmentWithInterval : dataSegmentWithIntervals) {
                descriptors.add(dataSegmentWithInterval.toRichSegmentDescriptor());
            }
            if (descriptors.isEmpty()) {
                retVal.add(NilInputSlice.INSTANCE);
                continue;
            }
            retVal.add(new SegmentsInputSlice(tableInputSpec.getDataSource(), descriptors));
        }
        return retVal;
    }

    private static class DataSegmentWithInterval {
        private final DataSegment segment;
        private final Interval interval;

        public DataSegmentWithInterval(DataSegment segment, Interval interval) {
            this.segment = (DataSegment)Preconditions.checkNotNull((Object)segment, (Object)"segment");
            this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        }

        public DataSegment getSegment() {
            return this.segment;
        }

        public RichSegmentDescriptor toRichSegmentDescriptor() {
            return new RichSegmentDescriptor(this.segment.getInterval(), this.interval, this.segment.getVersion(), this.segment.getShardSpec().getPartitionNum());
        }
    }
}

