/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.table;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.counters.CounterNames;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.ReadableInputs;
import org.apache.druid.msq.input.table.RichSegmentDescriptor;
import org.apache.druid.msq.input.table.SegmentWithDescriptor;
import org.apache.druid.msq.input.table.SegmentsInputSlice;
import org.apache.druid.msq.querykit.DataSegmentProvider;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.segment.Segment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class SegmentsInputSliceReader
implements InputSliceReader {
    private final DataSegmentProvider dataSegmentProvider;

    public SegmentsInputSliceReader(DataSegmentProvider dataSegmentProvider) {
        this.dataSegmentProvider = dataSegmentProvider;
    }

    @Override
    public int numReadableInputs(InputSlice slice) {
        SegmentsInputSlice segmentsInputSlice = (SegmentsInputSlice)slice;
        return segmentsInputSlice.getDescriptors().size();
    }

    @Override
    public ReadableInputs attach(int inputNumber, InputSlice slice, CounterTracker counters, Consumer<Throwable> warningPublisher) {
        SegmentsInputSlice segmentsInputSlice = (SegmentsInputSlice)slice;
        return ReadableInputs.segments(() -> Iterators.transform(this.dataSegmentIterator(segmentsInputSlice.getDataSource(), segmentsInputSlice.getDescriptors(), counters.channel(CounterNames.inputChannel(inputNumber)).setTotalFiles(slice.fileCount())), ReadableInput::segment));
    }

    private Iterator<SegmentWithDescriptor> dataSegmentIterator(String dataSource, List<RichSegmentDescriptor> descriptors, ChannelCounters channelCounters) {
        return descriptors.stream().map(descriptor -> {
            SegmentId segmentId = SegmentId.of((String)dataSource, (Interval)descriptor.getFullInterval(), (String)descriptor.getVersion(), (int)descriptor.getPartitionNumber());
            ResourceHolder<Segment> segmentHolder = this.dataSegmentProvider.fetchSegment(segmentId, channelCounters);
            return new SegmentWithDescriptor((ResourceHolder<? extends Segment>)segmentHolder, (SegmentDescriptor)descriptor);
        }).iterator();
    }
}

