/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import java.util.Objects;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.table.RichSegmentDescriptor;

@JsonTypeName(value="segments")
public class SegmentsInputSlice
implements InputSlice {
    private final String dataSource;
    private final List<RichSegmentDescriptor> descriptors;

    @JsonCreator
    public SegmentsInputSlice(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="segments") List<RichSegmentDescriptor> descriptors) {
        this.dataSource = dataSource;
        this.descriptors = descriptors;
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty(value="segments")
    public List<RichSegmentDescriptor> getDescriptors() {
        return this.descriptors;
    }

    @Override
    public int fileCount() {
        return this.descriptors.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentsInputSlice that = (SegmentsInputSlice)o;
        return Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.descriptors, that.descriptors);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.descriptors);
    }

    public String toString() {
        return "SegmentsInputSlice{dataSource='" + this.dataSource + '\'' + ", descriptors=" + this.descriptors + '}';
    }
}

