/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.table;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.Objects;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.segment.Segment;

public class SegmentWithDescriptor
implements Closeable {
    private final ResourceHolder<? extends Segment> segmentHolder;
    private final SegmentDescriptor descriptor;

    public SegmentWithDescriptor(ResourceHolder<? extends Segment> segmentHolder, SegmentDescriptor descriptor) {
        this.segmentHolder = (ResourceHolder)Preconditions.checkNotNull(segmentHolder, (Object)"segment");
        this.descriptor = (SegmentDescriptor)Preconditions.checkNotNull((Object)descriptor, (Object)"descriptor");
    }

    public Segment getOrLoadSegment() {
        return (Segment)this.segmentHolder.get();
    }

    @Override
    public void close() {
        this.segmentHolder.close();
    }

    public SegmentDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentWithDescriptor that = (SegmentWithDescriptor)o;
        return Objects.equals(this.segmentHolder, that.segmentHolder) && Objects.equals(this.descriptor, that.descriptor);
    }

    public int hashCode() {
        return Objects.hash(this.segmentHolder, this.descriptor);
    }
}

