/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.stage;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.input.stage.ReadablePartitions;
import org.apache.druid.msq.input.stage.StageInputSlice;
import org.apache.druid.msq.input.stage.StageInputSpec;

public class StageInputSpecSlicer
implements InputSpecSlicer {
    private final Int2ObjectMap<ReadablePartitions> stagePartitionsMap;

    public StageInputSpecSlicer(Int2ObjectMap<ReadablePartitions> stagePartitionsMap) {
        this.stagePartitionsMap = stagePartitionsMap;
    }

    @Override
    public boolean canSliceDynamic(InputSpec inputSpec) {
        return false;
    }

    @Override
    public List<InputSlice> sliceStatic(InputSpec inputSpec, int maxNumSlices) {
        StageInputSpec stageInputSpec = (StageInputSpec)inputSpec;
        ReadablePartitions stagePartitions = (ReadablePartitions)this.stagePartitionsMap.get(stageInputSpec.getStageNumber());
        if (stagePartitions == null) {
            throw new ISE("Stage [%d] not available", new Object[]{stageInputSpec.getStageNumber()});
        }
        List<ReadablePartitions> workerPartitions = stagePartitions.split(maxNumSlices);
        ArrayList<InputSlice> retVal = new ArrayList<InputSlice>();
        for (ReadablePartitions partitions : workerPartitions) {
            retVal.add(new StageInputSlice(stageInputSpec.getStageNumber(), partitions));
        }
        return retVal;
    }

    @Override
    public List<InputSlice> sliceDynamic(InputSpec inputSpec, int maxNumSlices, int maxFilesPerSlice, long maxBytesPerSlice) {
        throw new UnsupportedOperationException("Cannot sliceDynamic.");
    }
}

