/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.stage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.stage.ReadablePartitions;

@JsonTypeName(value="stage")
public class StageInputSlice
implements InputSlice {
    private final int stage;
    private final ReadablePartitions partitions;

    @JsonCreator
    public StageInputSlice(@JsonProperty(value="stage") int stageNumber, @JsonProperty(value="partitions") ReadablePartitions partitions) {
        this.stage = stageNumber;
        this.partitions = (ReadablePartitions)Preconditions.checkNotNull((Object)partitions, (Object)"partitions");
    }

    @JsonProperty(value="stage")
    public int getStageNumber() {
        return this.stage;
    }

    @JsonProperty(value="partitions")
    public ReadablePartitions getPartitions() {
        return this.partitions;
    }

    @Override
    public int fileCount() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StageInputSlice that = (StageInputSlice)o;
        return this.stage == that.stage && Objects.equals(this.partitions, that.partitions);
    }

    public int hashCode() {
        return Objects.hash(this.stage, this.partitions);
    }

    public String toString() {
        return "StageInputSpec{stage=" + this.stage + ", partitions=" + this.partitions + '}';
    }
}

