/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.stage;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import it.unimi.dsi.fastutil.ints.Int2IntAVLTreeMap;
import it.unimi.dsi.fastutil.ints.Int2IntSortedMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.msq.input.stage.CollectedReadablePartitions;
import org.apache.druid.msq.input.stage.CombinedReadablePartitions;
import org.apache.druid.msq.input.stage.ReadablePartition;
import org.apache.druid.msq.input.stage.StripedReadablePartitions;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="collected", value=CollectedReadablePartitions.class), @JsonSubTypes.Type(name="striped", value=StripedReadablePartitions.class), @JsonSubTypes.Type(name="combined", value=CombinedReadablePartitions.class)})
public interface ReadablePartitions
extends Iterable<ReadablePartition> {
    public List<ReadablePartitions> split(int var1);

    public static ReadablePartitions empty() {
        return new CombinedReadablePartitions(Collections.emptyList());
    }

    public static CombinedReadablePartitions combine(List<ReadablePartitions> readablePartitions) {
        return new CombinedReadablePartitions(readablePartitions);
    }

    public static StripedReadablePartitions striped(int stageNumber, int numWorkers, int numPartitions) {
        IntAVLTreeSet partitionNumbers = new IntAVLTreeSet();
        for (int i = 0; i < numPartitions; ++i) {
            partitionNumbers.add(i);
        }
        return new StripedReadablePartitions(stageNumber, numWorkers, (IntSortedSet)partitionNumbers);
    }

    public static CollectedReadablePartitions collected(int stageNumber, Map<Integer, Integer> partitionToWorkerMap) {
        if (partitionToWorkerMap instanceof Int2IntSortedMap) {
            return new CollectedReadablePartitions(stageNumber, (Int2IntSortedMap)partitionToWorkerMap);
        }
        return new CollectedReadablePartitions(stageNumber, (Int2IntSortedMap)new Int2IntAVLTreeMap(partitionToWorkerMap));
    }
}

