/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.external;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.data.input.InputFileAttribute;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.MaxSizeSplitHintSpec;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.InputSpecSlicer;
import org.apache.druid.msq.input.NilInputSlice;
import org.apache.druid.msq.input.SlicerUtils;
import org.apache.druid.msq.input.external.ExternalInputSlice;
import org.apache.druid.msq.input.external.ExternalInputSpec;
import org.apache.druid.segment.column.RowSignature;

public class ExternalInputSpecSlicer
implements InputSpecSlicer {
    @Override
    public boolean canSliceDynamic(InputSpec inputSpec) {
        return ((ExternalInputSpec)inputSpec).getInputSource().isSplittable();
    }

    @Override
    public List<InputSlice> sliceStatic(InputSpec inputSpec, int maxNumSlices) {
        List<List<Object>> workerInputSourcess;
        ExternalInputSpec externalInputSpec = (ExternalInputSpec)inputSpec;
        InputSource inputSource = externalInputSpec.getInputSource();
        InputFormat inputFormat = externalInputSpec.getInputFormat();
        RowSignature signature = externalInputSpec.getSignature();
        if (inputSource.isSplittable()) {
            SplittableInputSource splittableInputSource = (SplittableInputSource)inputSource;
            try {
                workerInputSourcess = SlicerUtils.makeSlices(splittableInputSource.createSplits(inputFormat, (SplitHintSpec)FilePerSplitHintSpec.INSTANCE).map(arg_0 -> ((SplittableInputSource)splittableInputSource).withSplit(arg_0)).iterator(), maxNumSlices);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            workerInputSourcess = Collections.singletonList(Collections.singletonList(inputSource));
        }
        if (workerInputSourcess.size() > maxNumSlices) {
            throw new ISE("Generated too many slices [%d > %d]", new Object[]{workerInputSourcess.size(), maxNumSlices});
        }
        return IntStream.range(0, maxNumSlices).mapToObj(workerNumber -> {
            List workerInputSources = workerNumber < workerInputSourcess.size() ? (List)workerInputSourcess.get(workerNumber) : Collections.emptyList();
            if (workerInputSources.isEmpty()) {
                return NilInputSlice.INSTANCE;
            }
            return new ExternalInputSlice(workerInputSources, inputFormat, signature);
        }).collect(Collectors.toList());
    }

    @Override
    public List<InputSlice> sliceDynamic(InputSpec inputSpec, int maxNumSlices, int maxFilesPerSlice, long maxBytesPerSlice) {
        long numSlices;
        ExternalInputSpec externalInputSpec = (ExternalInputSpec)inputSpec;
        if (!externalInputSpec.getInputSource().isSplittable()) {
            return this.sliceStatic(inputSpec, 1);
        }
        SplittableInputSource inputSource = (SplittableInputSource)externalInputSpec.getInputSource();
        MaxSizeSplitHintSpec maxSizeSplitHintSpec = new MaxSizeSplitHintSpec(new HumanReadableBytes(maxBytesPerSlice), Integer.valueOf(maxFilesPerSlice));
        try {
            numSlices = inputSource.createSplits(externalInputSpec.getInputFormat(), (SplitHintSpec)maxSizeSplitHintSpec).count();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.sliceStatic(inputSpec, (int)Math.min(numSlices, (long)maxNumSlices));
    }

    @VisibleForTesting
    static class FilePerSplitHintSpec
    implements SplitHintSpec {
        static FilePerSplitHintSpec INSTANCE = new FilePerSplitHintSpec();

        private FilePerSplitHintSpec() {
        }

        public <T> Iterator<List<T>> split(Iterator<T> inputIterator, Function<T, InputFileAttribute> inputAttributeExtractor) {
            return Iterators.transform(inputIterator, Collections::singletonList);
        }
    }
}

