/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input.external;

import com.google.common.collect.Iterators;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.druid.data.input.ColumnsFilter;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.InputSourceReader;
import org.apache.druid.data.input.impl.DimensionsSpec;
import org.apache.druid.data.input.impl.InlineInputSource;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.counters.CounterNames;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.counters.WarningCounters;
import org.apache.druid.msq.indexing.CountableInputSourceReader;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.NilInputSource;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.input.ReadableInputs;
import org.apache.druid.msq.input.external.ExternalInputSlice;
import org.apache.druid.msq.input.table.SegmentWithDescriptor;
import org.apache.druid.msq.querykit.LazyResourceHolder;
import org.apache.druid.msq.util.DimensionSchemaUtils;
import org.apache.druid.segment.RowAdapters;
import org.apache.druid.segment.RowBasedSegment;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.timeline.SegmentId;

public class ExternalInputSliceReader
implements InputSliceReader {
    private final File temporaryDirectory;

    public ExternalInputSliceReader(File temporaryDirectory) {
        this.temporaryDirectory = temporaryDirectory;
    }

    @Override
    public int numReadableInputs(InputSlice slice) {
        ExternalInputSlice externalInputSlice = (ExternalInputSlice)slice;
        return externalInputSlice.getInputSources().size();
    }

    @Override
    public ReadableInputs attach(int inputNumber, InputSlice slice, CounterTracker counters, Consumer<Throwable> warningPublisher) {
        ExternalInputSlice externalInputSlice = (ExternalInputSlice)slice;
        return ReadableInputs.segments(() -> Iterators.transform(ExternalInputSliceReader.inputSourceSegmentIterator(externalInputSlice.getInputSources(), externalInputSlice.getInputFormat(), externalInputSlice.getSignature(), this.temporaryDirectory, counters.channel(CounterNames.inputChannel(inputNumber)).setTotalFiles(slice.fileCount()), counters.warnings(), warningPublisher), ReadableInput::segment));
    }

    private static Iterator<SegmentWithDescriptor> inputSourceSegmentIterator(List<InputSource> inputSources, InputFormat inputFormat, RowSignature signature, File temporaryDirectory, final ChannelCounters channelCounters, final WarningCounters warningCounters, final Consumer<Throwable> warningPublisher) {
        InputRowSchema schema = new InputRowSchema(new TimestampSpec("__dummy__", "auto", DateTimes.utc((long)0L)), new DimensionsSpec(signature.getColumnNames().stream().map(column -> DimensionSchemaUtils.createDimensionSchema(column, signature.getColumnType(column).orElse(null))).collect(Collectors.toList())), ColumnsFilter.all());
        if (!temporaryDirectory.exists() && !temporaryDirectory.mkdir()) {
            throw new ISE("Cannot create temporary directory at [%s]", new Object[]{temporaryDirectory});
        }
        return Iterators.transform(inputSources.iterator(), inputSource -> {
            final boolean incrementCounters = ExternalInputSliceReader.isFileBasedInputSource(inputSource);
            final InputSourceReader reader = incrementCounters ? new CountableInputSourceReader(inputSource.reader(schema, inputFormat, temporaryDirectory), channelCounters) : inputSource.reader(schema, inputFormat, temporaryDirectory);
            SegmentId segmentId = SegmentId.dummy((String)"dummy");
            RowBasedSegment segment = new RowBasedSegment(segmentId, (Sequence)new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<InputRow, CloseableIterator<InputRow>>(){

                public CloseableIterator<InputRow> make() {
                    try {
                        final CloseableIterator baseIterator = reader.read();
                        return new CloseableIterator<InputRow>(){
                            private InputRow next = null;

                            public void close() throws IOException {
                                baseIterator.close();
                            }

                            public boolean hasNext() {
                                while (true) {
                                    try {
                                        while (this.next == null && baseIterator.hasNext()) {
                                            this.next = (InputRow)baseIterator.next();
                                        }
                                    }
                                    catch (ParseException e) {
                                        warningCounters.incrementWarningCount("CannotParseExternalData");
                                        warningPublisher.accept(e);
                                        continue;
                                    }
                                    break;
                                }
                                return this.next != null;
                            }

                            public InputRow next() {
                                if (!this.hasNext()) {
                                    throw new NoSuchElementException();
                                }
                                InputRow row = this.next;
                                this.next = null;
                                return row;
                            }
                        };
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void cleanup(CloseableIterator<InputRow> iterFromMake) {
                    try {
                        iterFromMake.close();
                        if (incrementCounters) {
                            channelCounters.incrementFileCount();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }), RowAdapters.standardRow(), signature);
            return new SegmentWithDescriptor(new LazyResourceHolder(() -> Pair.of((Object)segment, () -> {})), segmentId.toDescriptor());
        });
    }

    static boolean isFileBasedInputSource(InputSource inputSource) {
        return !(inputSource instanceof NilInputSource) && !(inputSource instanceof InlineInputSource);
    }
}

