/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.function.ToLongFunction;

public class SlicerUtils {
    public static <T> List<List<T>> makeSlices(Iterator<T> iterator, int numSlices) {
        ArrayList<List<T>> slicesList = new ArrayList<List<T>>(numSlices);
        while (slicesList.size() < numSlices) {
            slicesList.add(new ArrayList());
        }
        int i = 0;
        while (iterator.hasNext()) {
            T obj = iterator.next();
            ((List)slicesList.get(i % numSlices)).add(obj);
            ++i;
        }
        return slicesList;
    }

    public static <T> List<List<T>> makeSlices(Iterator<T> iterator, ToLongFunction<T> weightFunction, int numSlices) {
        ArrayList<List<T>> slicesList = new ArrayList<List<T>>(numSlices);
        PriorityQueue<ListWithWeight> pq = new PriorityQueue<ListWithWeight>(numSlices, Comparator.comparing(ListWithWeight::getWeight).thenComparing(ListWithWeight::getPosition));
        while (slicesList.size() < numSlices) {
            ArrayList list = new ArrayList();
            pq.add(new ListWithWeight(list, pq.size(), 0L));
            slicesList.add(list);
        }
        while (iterator.hasNext()) {
            T obj = iterator.next();
            long itemWeight = weightFunction.applyAsLong(obj);
            ListWithWeight listWithWeight = (ListWithWeight)pq.remove();
            listWithWeight.getList().add(obj);
            pq.add(new ListWithWeight(listWithWeight.getList(), listWithWeight.getPosition(), listWithWeight.getWeight() + itemWeight));
        }
        return slicesList;
    }

    private static class ListWithWeight<T> {
        private final List<T> list;
        private final int position;
        private final long totalSize;

        public ListWithWeight(List<T> list, int position, long totalSize) {
            this.list = list;
            this.position = position;
            this.totalSize = totalSize;
        }

        public List<T> getList() {
            return this.list;
        }

        public int getPosition() {
            return this.position;
        }

        public long getWeight() {
            return this.totalSize;
        }
    }
}

