/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.input.table.SegmentWithDescriptor;
import org.apache.druid.msq.kernel.StagePartition;

public class ReadableInput {
    @Nullable
    private final SegmentWithDescriptor segment;
    @Nullable
    private final ReadableFrameChannel inputChannel;
    @Nullable
    private final FrameReader frameReader;
    @Nullable
    private final StagePartition stagePartition;

    private ReadableInput(@Nullable SegmentWithDescriptor segment, @Nullable ReadableFrameChannel channel, @Nullable FrameReader frameReader, @Nullable StagePartition stagePartition) {
        this.segment = segment;
        this.inputChannel = channel;
        this.frameReader = frameReader;
        this.stagePartition = stagePartition;
        if (segment == null == (channel == null)) {
            throw new ISE("Provide either 'segment' or 'channel'", new Object[0]);
        }
    }

    public static ReadableInput segment(SegmentWithDescriptor segment) {
        return new ReadableInput(segment, null, null, null);
    }

    public static ReadableInput channel(ReadableFrameChannel inputChannel, FrameReader frameReader, StagePartition stagePartition) {
        return new ReadableInput(null, inputChannel, frameReader, stagePartition);
    }

    public boolean hasSegment() {
        return this.segment != null;
    }

    public boolean hasChannel() {
        return this.inputChannel != null;
    }

    public SegmentWithDescriptor getSegment() {
        return (SegmentWithDescriptor)Preconditions.checkNotNull((Object)this.segment, (Object)"segment");
    }

    public ReadableFrameChannel getChannel() {
        return (ReadableFrameChannel)Preconditions.checkNotNull((Object)this.inputChannel, (Object)"channel");
    }

    public FrameReader getChannelFrameReader() {
        return (FrameReader)Preconditions.checkNotNull((Object)this.frameReader, (Object)"frameReader");
    }

    @Nullable
    public StagePartition getStagePartition() {
        return this.stagePartition;
    }
}

