/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.input;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.stage.ReadablePartitions;
import org.apache.druid.msq.input.stage.StageInputSlice;

public class InputSlices {
    private InputSlices() {
    }

    public static ReadablePartitions allReadablePartitions(List<InputSlice> slices) {
        ArrayList<ReadablePartitions> partitionsList = new ArrayList<ReadablePartitions>();
        for (InputSlice slice : slices) {
            if (!(slice instanceof StageInputSlice)) continue;
            partitionsList.add(((StageInputSlice)slice).getPartitions());
        }
        return ReadablePartitions.combine(partitionsList);
    }

    public static int getNumNonBroadcastReadableInputs(List<InputSlice> slices, InputSliceReader reader, IntSet broadcastInputs) {
        int numInputs = 0;
        for (int i = 0; i < slices.size(); ++i) {
            if (broadcastInputs.contains(i)) continue;
            numInputs += reader.numReadableInputs(slices.get(i));
        }
        return numInputs;
    }
}

