/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.report;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.segment.column.RowSignature;

public class MSQResultsReport {
    private final RowSignature signature;
    @Nullable
    private final List<String> sqlTypeNames;
    private final Yielder<Object[]> resultYielder;

    public MSQResultsReport(RowSignature signature, @Nullable List<String> sqlTypeNames, Yielder<Object[]> resultYielder) {
        this.signature = (RowSignature)Preconditions.checkNotNull((Object)signature, (Object)"signature");
        this.sqlTypeNames = sqlTypeNames;
        this.resultYielder = (Yielder)Preconditions.checkNotNull(resultYielder, (Object)"resultYielder");
    }

    @JsonCreator
    static MSQResultsReport fromJson(@JsonProperty(value="signature") RowSignature signature, @JsonProperty(value="sqlTypeNames") @Nullable List<String> sqlTypeNames, @JsonProperty(value="results") List<Object[]> results) {
        return new MSQResultsReport(signature, sqlTypeNames, (Yielder<Object[]>)Yielders.each((Sequence)Sequences.simple(results)));
    }

    @JsonProperty(value="signature")
    public RowSignature getSignature() {
        return this.signature;
    }

    @Nullable
    @JsonProperty(value="sqlTypeNames")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getSqlTypeNames() {
        return this.sqlTypeNames;
    }

    @JsonProperty(value="results")
    public Yielder<Object[]> getResultYielder() {
        return this.resultYielder;
    }
}

