/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="TaskStartTimeout")
public class TaskStartTimeoutFault
extends BaseMSQFault {
    static final String CODE = "TaskStartTimeout";
    private final int numTasks;

    @JsonCreator
    public TaskStartTimeoutFault(@JsonProperty(value="numTasks") int numTasks) {
        super(CODE, "Unable to launch all the worker tasks in time. There might be insufficient available slots to start all the worker tasks simultaneously. Try lowering '%s' in your query context to lower than [%d] tasks, or increasing capacity.", "maxNumTasks", numTasks);
        this.numTasks = numTasks;
    }

    @JsonProperty
    public int getNumTasks() {
        return this.numTasks;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskStartTimeoutFault that = (TaskStartTimeoutFault)o;
        return this.numTasks == that.numTasks;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.numTasks);
    }
}

