/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="NotEnoughMemory")
public class NotEnoughMemoryFault
extends BaseMSQFault {
    static final String CODE = "NotEnoughMemory";
    private final long serverMemory;
    private final long usableMemory;
    private final int serverWorkers;
    private final int serverThreads;

    @JsonCreator
    public NotEnoughMemoryFault(@JsonProperty(value="serverMemory") long serverMemory, @JsonProperty(value="usableMemory") long usableMemory, @JsonProperty(value="serverWorkers") int serverWorkers, @JsonProperty(value="serverThreads") int serverThreads) {
        super(CODE, "Not enough memory (total = %,d; usable = %,d; server workers = %,d; server threads = %,d)", serverMemory, usableMemory, serverWorkers, serverThreads);
        this.serverMemory = serverMemory;
        this.usableMemory = usableMemory;
        this.serverWorkers = serverWorkers;
        this.serverThreads = serverThreads;
    }

    @JsonProperty
    public long getServerMemory() {
        return this.serverMemory;
    }

    @JsonProperty
    public long getUsableMemory() {
        return this.usableMemory;
    }

    @JsonProperty
    public int getServerWorkers() {
        return this.serverWorkers;
    }

    @JsonProperty
    public int getServerThreads() {
        return this.serverThreads;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NotEnoughMemoryFault that = (NotEnoughMemoryFault)o;
        return this.serverMemory == that.serverMemory && this.usableMemory == that.usableMemory && this.serverWorkers == that.serverWorkers && this.serverThreads == that.serverThreads;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.serverMemory, this.usableMemory, this.serverWorkers, this.serverThreads);
    }

    @Override
    public String toString() {
        return "NotEnoughMemoryFault{serverMemory=" + this.serverMemory + ", usableMemory=" + this.usableMemory + ", serverWorkers=" + this.serverWorkers + ", serverThreads=" + this.serverThreads + '}';
    }
}

