/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.frame.processor.FrameRowTooLargeException;
import org.apache.druid.frame.write.UnsupportedColumnTypeException;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.msq.indexing.error.CannotParseExternalDataFault;
import org.apache.druid.msq.indexing.error.ColumnTypeNotSupportedFault;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.MSQFault;
import org.apache.druid.msq.indexing.error.RowTooLargeFault;
import org.apache.druid.msq.indexing.error.TooManyBucketsFault;
import org.apache.druid.msq.indexing.error.UnknownFault;
import org.apache.druid.msq.statistics.TooManyBucketsException;

public class MSQErrorReport {
    private final String taskId;
    @Nullable
    private final String host;
    @Nullable
    private final Integer stageNumber;
    private final MSQFault error;
    @Nullable
    private final String exceptionStackTrace;

    @JsonCreator
    MSQErrorReport(@JsonProperty(value="taskId") String taskId, @JsonProperty(value="host") @Nullable String host, @JsonProperty(value="stageNumber") Integer stageNumber, @JsonProperty(value="error") MSQFault fault, @JsonProperty(value="exceptionStackTrace") @Nullable String exceptionStackTrace) {
        this.taskId = (String)Preconditions.checkNotNull((Object)taskId, (Object)"taskId");
        this.host = host;
        this.stageNumber = stageNumber;
        this.error = (MSQFault)Preconditions.checkNotNull((Object)fault, (Object)"error");
        this.exceptionStackTrace = exceptionStackTrace;
    }

    public static MSQErrorReport fromFault(String taskId, @Nullable String host, @Nullable Integer stageNumber, MSQFault fault) {
        return new MSQErrorReport(taskId, host, stageNumber, fault, null);
    }

    public static MSQErrorReport fromException(String taskId, @Nullable String host, @Nullable Integer stageNumber, Throwable e) {
        return new MSQErrorReport(taskId, host, stageNumber, MSQErrorReport.getFaultFromException(e), Throwables.getStackTraceAsString((Throwable)e));
    }

    @JsonProperty
    public String getTaskId() {
        return this.taskId;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getHost() {
        return this.host;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getStageNumber() {
        return this.stageNumber;
    }

    @JsonProperty(value="error")
    public MSQFault getFault() {
        return this.error;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getExceptionStackTrace() {
        return this.exceptionStackTrace;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MSQErrorReport that = (MSQErrorReport)o;
        return Objects.equals(this.taskId, that.taskId) && Objects.equals(this.host, that.host) && Objects.equals(this.stageNumber, that.stageNumber) && Objects.equals(this.error, that.error) && Objects.equals(this.exceptionStackTrace, that.exceptionStackTrace);
    }

    public int hashCode() {
        return Objects.hash(this.taskId, this.host, this.error, this.exceptionStackTrace);
    }

    public String toString() {
        return "MSQErrorReport{taskId='" + this.taskId + '\'' + ", host='" + this.host + '\'' + ", stageNumber=" + this.stageNumber + ", error=" + this.error + ", exceptionStackTrace='" + this.exceptionStackTrace + '\'' + '}';
    }

    public static MSQFault getFaultFromException(@Nullable Throwable e) {
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (cause instanceof MSQException) {
                return ((MSQException)cause).getFault();
            }
            if (cause instanceof ParseException) {
                return new CannotParseExternalDataFault(cause.getMessage());
            }
            if (cause instanceof UnsupportedColumnTypeException) {
                UnsupportedColumnTypeException unsupportedColumnTypeException = (UnsupportedColumnTypeException)cause;
                return new ColumnTypeNotSupportedFault(unsupportedColumnTypeException.getColumnName(), unsupportedColumnTypeException.getColumnType());
            }
            if (cause instanceof TooManyBucketsException) {
                return new TooManyBucketsFault(((TooManyBucketsException)cause).getMaxBuckets());
            }
            if (!(cause instanceof FrameRowTooLargeException)) continue;
            return new RowTooLargeFault(((FrameRowTooLargeException)cause).getMaxFrameSize());
        }
        return UnknownFault.forException(e);
    }
}

