/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="InsertCannotOrderByDescending")
public class InsertCannotOrderByDescendingFault
extends BaseMSQFault {
    static final String CODE = "InsertCannotOrderByDescending";
    private final String columnName;

    @JsonCreator
    public InsertCannotOrderByDescendingFault(@JsonProperty(value="columnName") String columnName) {
        super(CODE, "Cannot ingest column [%s] in descending order", columnName, new Object[0]);
        this.columnName = (String)Preconditions.checkNotNull((Object)columnName, (Object)"columnName");
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertCannotOrderByDescendingFault that = (InsertCannotOrderByDescendingFault)o;
        return Objects.equals(this.columnName, that.columnName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.columnName);
    }
}

