/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;
import org.joda.time.Interval;

@JsonTypeName(value="InsertCannotAllocateSegment")
public class InsertCannotAllocateSegmentFault
extends BaseMSQFault {
    static final String CODE = "InsertCannotAllocateSegment";
    private final String dataSource;
    private final Interval interval;

    @JsonCreator
    public InsertCannotAllocateSegmentFault(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval) {
        super(CODE, "Cannot allocate segment for dataSource [%s], interval [%s]", dataSource, interval);
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsertCannotAllocateSegmentFault that = (InsertCannotAllocateSegmentFault)o;
        return Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.interval, that.interval);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.dataSource, this.interval);
    }
}

