/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.counters.CounterNames;
import org.apache.druid.msq.counters.CounterSnapshots;
import org.apache.druid.msq.counters.CounterSnapshotsTree;
import org.apache.druid.msq.counters.WarningCounters;

public class FaultsExceededChecker {
    final Map<String, Long> maxFaultsAllowedCount;

    public FaultsExceededChecker(Map<String, Long> maxFaultsAllowedCount) {
        maxFaultsAllowedCount.forEach((warning, count) -> Preconditions.checkArgument((count >= 0L || count == -1L ? 1 : 0) != 0, (Object)StringUtils.format((String)"Invalid limit of %d supplied for warnings of type %s. Limit can be greater than or equal to -1.", (Object[])new Object[]{count, warning})));
        this.maxFaultsAllowedCount = maxFaultsAllowedCount;
    }

    public Optional<Pair<String, Long>> addFaultsAndCheckIfExceeded(CounterSnapshotsTree snapshotsTree) {
        Map<Integer, Map<Integer, CounterSnapshots>> snapshotsMap = snapshotsTree.copyMap();
        HashMap<String, Long> allWarnings = new HashMap<String, Long>();
        for (Map.Entry<Integer, Map<Integer, CounterSnapshots>> entry : snapshotsMap.entrySet()) {
            for (Map.Entry<Integer, CounterSnapshots> workerEntry : entry.getValue().entrySet()) {
                WarningCounters.Snapshot warningsSnapshot = (WarningCounters.Snapshot)workerEntry.getValue().getMap().get(CounterNames.warnings());
                if (warningsSnapshot == null) continue;
                for (Map.Entry<String, Long> entry2 : warningsSnapshot.getWarningCountMap().entrySet()) {
                    allWarnings.compute(entry2.getKey(), (ignored, value) -> value == null ? (Long)entry2.getValue() : Long.valueOf(value + (Long)entry2.getValue()));
                }
            }
        }
        for (Map.Entry<Integer, Map<Integer, CounterSnapshots>> entry : allWarnings.entrySet()) {
            long limit = this.maxFaultsAllowedCount.getOrDefault(entry.getKey(), -1L);
            boolean passed = limit == -1L || (Long)((Object)entry.getValue()) <= limit;
            if (passed) continue;
            return Optional.of(Pair.of((Object)entry.getKey(), (Object)limit));
        }
        return Optional.empty();
    }
}

