/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.frame.write.UnsupportedColumnTypeException;
import org.apache.druid.msq.indexing.error.BaseMSQFault;
import org.apache.druid.segment.column.ColumnType;

@JsonTypeName(value="ColumnTypeNotSupported")
public class ColumnTypeNotSupportedFault
extends BaseMSQFault {
    static final String CODE = "ColumnTypeNotSupported";
    private final String columnName;
    @Nullable
    private final ColumnType columnType;

    @JsonCreator
    public ColumnTypeNotSupportedFault(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="columnType") @Nullable ColumnType columnType) {
        super(CODE, UnsupportedColumnTypeException.message((String)columnName, (ColumnType)columnType));
        this.columnName = (String)Preconditions.checkNotNull((Object)columnName, (Object)"columnName");
        this.columnType = columnType;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ColumnType getColumnType() {
        return this.columnType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ColumnTypeNotSupportedFault that = (ColumnTypeNotSupportedFault)o;
        return Objects.equals(this.columnName, that.columnName) && Objects.equals(this.columnType, that.columnType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.columnName, this.columnType);
    }
}

