/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="ColumnNameRestricted")
public class ColumnNameRestrictedFault
extends BaseMSQFault {
    static final String CODE = "ColumnNameRestricted";
    private final String columnName;

    @JsonCreator
    public ColumnNameRestrictedFault(@JsonProperty(value="columnName") String columnName) {
        super(CODE, StringUtils.format((String)"[%s] column name is reserved for MSQ's internal purpose. Please retry the query after renaming the column.", (Object[])new Object[]{columnName}));
        this.columnName = (String)Preconditions.checkNotNull((Object)columnName, (Object)"columnName");
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ColumnNameRestrictedFault that = (ColumnNameRestrictedFault)o;
        return Objects.equals(this.columnName, that.columnName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.columnName);
    }
}

