/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="BroadcastTablesTooLarge")
public class BroadcastTablesTooLargeFault
extends BaseMSQFault {
    static final String CODE = "BroadcastTablesTooLarge";
    private final long maxBroadcastTablesSize;

    @JsonCreator
    public BroadcastTablesTooLargeFault(@JsonProperty(value="maxBroadcastTablesSize") long maxBroadcastTablesSize) {
        super(CODE, "Size of the broadcast tables exceed the memory reserved for them (memory reserved for broadcast tables = %d bytes)", maxBroadcastTablesSize, new Object[0]);
        this.maxBroadcastTablesSize = maxBroadcastTablesSize;
    }

    @JsonProperty
    public long getMaxBroadcastTablesSize() {
        return this.maxBroadcastTablesSize;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BroadcastTablesTooLargeFault that = (BroadcastTablesTooLargeFault)o;
        return this.maxBroadcastTablesSize == that.maxBroadcastTablesSize;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxBroadcastTablesSize);
    }
}

