/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.mutable.MutableLong;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.exec.Worker;
import org.apache.druid.msq.indexing.MSQWorkerTask;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.kernel.WorkOrder;
import org.apache.druid.msq.statistics.ClusterByStatisticsSnapshot;
import org.apache.druid.segment.realtime.firehose.ChatHandler;
import org.apache.druid.segment.realtime.firehose.ChatHandlers;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.utils.CloseableUtils;

public class WorkerChatHandler
implements ChatHandler {
    private static final Logger log = new Logger(WorkerChatHandler.class);
    private static final long CHANNEL_DATA_CHUNK_SIZE = 1000000L;
    private final Worker worker;
    private final MSQWorkerTask task;
    private final TaskToolbox toolbox;

    public WorkerChatHandler(TaskToolbox toolbox, Worker worker) {
        this.worker = worker;
        this.task = worker.task();
        this.toolbox = toolbox;
    }

    @GET
    @Path(value="/channels/{queryId}/{stageNumber}/{partitionNumber}")
    @Produces(value={"application/octet-stream"})
    public Response httpGetChannelData(@PathParam(value="queryId") String queryId, @PathParam(value="stageNumber") int stageNumber, @PathParam(value="partitionNumber") int partitionNumber, @QueryParam(value="offset") long offset, @Context HttpServletRequest req) {
        ChatHandlers.authorizationCheck((HttpServletRequest)req, (Action)Action.WRITE, (String)this.task.getDataSource(), (AuthorizerMapper)this.toolbox.getAuthorizerMapper());
        try {
            InputStream inputStream = this.worker.readChannel(queryId, stageNumber, partitionNumber, offset);
            if (inputStream == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Response.ResponseBuilder responseBuilder = Response.ok();
            byte[] readBuf = new byte[8192];
            MutableLong bytesReadTotal = new MutableLong(0L);
            int firstRead = inputStream.read(readBuf);
            if (firstRead == -1) {
                inputStream.close();
                return responseBuilder.header("X-Druid-Frame-Last-Fetch", (Object)"yes").entity((Object)ByteArrays.EMPTY_ARRAY).build();
            }
            return Response.ok(output -> {
                try {
                    int bytesReadThisCall = firstRead;
                    do {
                        int bytesToWrite = (int)Math.min(1000000L - bytesReadTotal.longValue(), (long)bytesReadThisCall);
                        output.write(readBuf, 0, bytesToWrite);
                        bytesReadTotal.add((long)bytesReadThisCall);
                    } while (bytesReadTotal.longValue() < 1000000L && (bytesReadThisCall = inputStream.read(readBuf)) != -1);
                }
                catch (Throwable e) {
                    try {
                        log.noStackTrace().warn(e, "Error writing channel for query [%s] stage [%s] partition [%s] offset [%,d] to [%s]", new Object[]{queryId, stageNumber, partitionNumber, offset, req.getRemoteAddr()});
                    }
                    catch (Throwable throwable) {
                        CloseableUtils.closeAll((Closeable)inputStream, (Closeable[])new Closeable[]{output});
                        throw throwable;
                    }
                    CloseableUtils.closeAll((Closeable)inputStream, (Closeable[])new Closeable[]{output});
                }
                CloseableUtils.closeAll((Closeable)inputStream, (Closeable[])new Closeable[]{output});
            }).build();
        }
        catch (IOException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/workOrder")
    public Response httpPostWorkOrder(WorkOrder workOrder, @Context HttpServletRequest req) {
        ChatHandlers.authorizationCheck((HttpServletRequest)req, (Action)Action.WRITE, (String)this.task.getDataSource(), (AuthorizerMapper)this.toolbox.getAuthorizerMapper());
        this.worker.postWorkOrder(workOrder);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/resultPartitionBoundaries/{queryId}/{stageNumber}")
    public Response httpPostResultPartitionBoundaries(ClusterByPartitions stagePartitionBoundaries, @PathParam(value="queryId") String queryId, @PathParam(value="stageNumber") int stageNumber, @Context HttpServletRequest req) {
        ChatHandlers.authorizationCheck((HttpServletRequest)req, (Action)Action.WRITE, (String)this.task.getDataSource(), (AuthorizerMapper)this.toolbox.getAuthorizerMapper());
        if (this.worker.postResultPartitionBoundaries(stagePartitionBoundaries, queryId, stageNumber)) {
            return Response.status((Response.Status)Response.Status.ACCEPTED).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }

    @POST
    @Path(value="/keyStatistics/{queryId}/{stageNumber}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response httpFetchKeyStatistics(@PathParam(value="queryId") String queryId, @PathParam(value="stageNumber") int stageNumber, @Context HttpServletRequest req) {
        ChatHandlers.authorizationCheck((HttpServletRequest)req, (Action)Action.READ, (String)this.task.getDataSource(), (AuthorizerMapper)this.toolbox.getAuthorizerMapper());
        StageId stageId = new StageId(queryId, stageNumber);
        try {
            ClusterByStatisticsSnapshot clusterByStatisticsSnapshot = this.worker.fetchStatisticsSnapshot(stageId);
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)clusterByStatisticsSnapshot).build();
        }
        catch (Exception e) {
            String errorMessage = StringUtils.format((String)"Invalid request for key statistics for query[%s] and stage[%d]", (Object[])new Object[]{queryId, stageNumber});
            log.error((Throwable)e, errorMessage, new Object[0]);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)errorMessage)).build();
        }
    }

    @POST
    @Path(value="/keyStatisticsForTimeChunk/{queryId}/{stageNumber}/{timeChunk}")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response httpFetchKeyStatisticsWithSnapshot(@PathParam(value="queryId") String queryId, @PathParam(value="stageNumber") int stageNumber, @PathParam(value="timeChunk") long timeChunk, @Context HttpServletRequest req) {
        ChatHandlers.authorizationCheck((HttpServletRequest)req, (Action)Action.READ, (String)this.task.getDataSource(), (AuthorizerMapper)this.toolbox.getAuthorizerMapper());
        StageId stageId = new StageId(queryId, stageNumber);
        try {
            ClusterByStatisticsSnapshot snapshotForTimeChunk = this.worker.fetchStatisticsSnapshotForTimeChunk(stageId, timeChunk);
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)snapshotForTimeChunk).build();
        }
        catch (Exception e) {
            String errorMessage = StringUtils.format((String)"Invalid request for key statistics for query[%s], stage[%d] and timeChunk[%d]", (Object[])new Object[]{queryId, stageNumber, timeChunk});
            log.error((Throwable)e, errorMessage, new Object[0]);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)errorMessage)).build();
        }
    }

    @POST
    @Path(value="/cleanupStage/{queryId}/{stageNumber}")
    public Response httpPostCleanupStage(@PathParam(value="queryId") String queryId, @PathParam(value="stageNumber") int stageNumber, @Context HttpServletRequest req) {
        ChatHandlers.authorizationCheck((HttpServletRequest)req, (Action)Action.WRITE, (String)this.task.getDataSource(), (AuthorizerMapper)this.toolbox.getAuthorizerMapper());
        this.worker.postCleanupStage(new StageId(queryId, stageNumber));
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="/finish")
    public Response httpPostFinish(@Context HttpServletRequest req) {
        ChatHandlers.authorizationCheck((HttpServletRequest)req, (Action)Action.WRITE, (String)this.task.getDataSource(), (AuthorizerMapper)this.toolbox.getAuthorizerMapper());
        this.worker.postFinish();
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/counters")
    public Response httpGetCounters(@Context HttpServletRequest req) {
        ChatHandlers.authorizationCheck((HttpServletRequest)req, (Action)Action.WRITE, (String)this.task.getDataSource(), (AuthorizerMapper)this.toolbox.getAuthorizerMapper());
        return Response.status((Response.Status)Response.Status.OK).entity((Object)this.worker.getCounters()).build();
    }
}

