/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.druid.frame.processor.OutputChannelFactory;
import org.apache.druid.frame.processor.OutputChannels;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.msq.counters.CounterTracker;
import org.apache.druid.msq.exec.WorkerMemoryParameters;
import org.apache.druid.msq.indexing.ColumnMappings;
import org.apache.druid.msq.indexing.MSQTuningConfig;
import org.apache.druid.msq.indexing.SegmentGeneratorFrameProcessor;
import org.apache.druid.msq.input.InputSlice;
import org.apache.druid.msq.input.InputSliceReader;
import org.apache.druid.msq.input.ReadableInput;
import org.apache.druid.msq.kernel.ExtraInfoHolder;
import org.apache.druid.msq.kernel.FrameContext;
import org.apache.druid.msq.kernel.FrameProcessorFactory;
import org.apache.druid.msq.kernel.ProcessorsAndChannels;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StagePartition;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexMerger;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.data.CompressionFactory;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.loading.DataSegmentPusher;
import org.apache.druid.segment.realtime.FireDepartmentMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.Appenderators;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Period;

@JsonTypeName(value="segmentGenerator")
public class SegmentGeneratorFrameProcessorFactory
implements FrameProcessorFactory<List<SegmentIdWithShardSpec>, SegmentGeneratorFrameProcessor, DataSegment, Set<DataSegment>> {
    private final DataSchema dataSchema;
    private final ColumnMappings columnMappings;
    private final MSQTuningConfig tuningConfig;

    @JsonCreator
    public SegmentGeneratorFrameProcessorFactory(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="columnMappings") ColumnMappings columnMappings, @JsonProperty(value="tuningConfig") MSQTuningConfig tuningConfig) {
        this.dataSchema = (DataSchema)Preconditions.checkNotNull((Object)dataSchema, (Object)"dataSchema");
        this.columnMappings = (ColumnMappings)Preconditions.checkNotNull((Object)columnMappings, (Object)"columnMappings");
        this.tuningConfig = (MSQTuningConfig)Preconditions.checkNotNull((Object)tuningConfig, (Object)"tuningConfig");
    }

    @JsonProperty
    public DataSchema getDataSchema() {
        return this.dataSchema;
    }

    @JsonProperty
    public ColumnMappings getColumnMappings() {
        return this.columnMappings;
    }

    @JsonProperty
    public MSQTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    @Override
    public ProcessorsAndChannels<SegmentGeneratorFrameProcessor, DataSegment> makeProcessors(StageDefinition stageDefinition, int workerNumber, List<InputSlice> inputSlices, InputSliceReader inputSliceReader, @Nullable List<SegmentIdWithShardSpec> extra, OutputChannelFactory outputChannelFactory, FrameContext frameContext, int maxOutstandingProcessors, CounterTracker counters, Consumer<Throwable> warningPublisher) {
        RowIngestionMeters meters = frameContext.rowIngestionMeters();
        ParseExceptionHandler parseExceptionHandler = new ParseExceptionHandler(meters, false, Integer.MAX_VALUE, 0);
        InputSlice slice = (InputSlice)Iterables.getOnlyElement(inputSlices);
        Sequence inputSequence = Sequences.simple((Iterable)Iterables.transform((Iterable)inputSliceReader.attach(0, slice, counters, warningPublisher), (Function)new Function<ReadableInput, Pair<Integer, ReadableInput>>(){
            int i = 0;

            public Pair<Integer, ReadableInput> apply(ReadableInput readableInput) {
                return Pair.of((Object)this.i++, (Object)readableInput);
            }
        }));
        Sequence workers = inputSequence.map(readableInputPair -> {
            StagePartition stagePartition = (StagePartition)Preconditions.checkNotNull((Object)((ReadableInput)readableInputPair.rhs).getStagePartition());
            SegmentIdWithShardSpec segmentIdWithShardSpec = (SegmentIdWithShardSpec)extra.get((Integer)readableInputPair.lhs);
            String idString = StringUtils.format((String)"%s:%s", (Object[])new Object[]{stagePartition, workerNumber});
            File persistDirectory = new File(frameContext.persistDir(), segmentIdWithShardSpec.asSegmentId().toString());
            Appenderator appenderator = Appenderators.createOffline((String)idString, (DataSchema)this.dataSchema, (AppenderatorConfig)SegmentGeneratorFrameProcessorFactory.makeAppenderatorConfig(this.tuningConfig, persistDirectory, frameContext.memoryParameters()), (FireDepartmentMetrics)new FireDepartmentMetrics(), (DataSegmentPusher)frameContext.segmentPusher(), (ObjectMapper)frameContext.jsonMapper(), (IndexIO)frameContext.indexIO(), (IndexMerger)frameContext.indexMerger(), (RowIngestionMeters)meters, (ParseExceptionHandler)parseExceptionHandler, (boolean)true);
            return new SegmentGeneratorFrameProcessor((ReadableInput)readableInputPair.rhs, this.columnMappings, this.dataSchema.getDimensionsSpec().getDimensionNames(), appenderator, segmentIdWithShardSpec);
        });
        return new ProcessorsAndChannels<SegmentGeneratorFrameProcessor, DataSegment>(workers, OutputChannels.none());
    }

    @Override
    public TypeReference<Set<DataSegment>> getAccumulatedResultTypeReference() {
        return new TypeReference<Set<DataSegment>>(){};
    }

    @Override
    public Set<DataSegment> newAccumulatedResult() {
        return new HashSet<DataSegment>();
    }

    @Override
    @Nullable
    public Set<DataSegment> accumulateResult(Set<DataSegment> accumulated, DataSegment current) {
        if (current != null) {
            accumulated.add(current);
        }
        return accumulated;
    }

    @Override
    @Nullable
    public Set<DataSegment> mergeAccumulatedResult(Set<DataSegment> accumulated, Set<DataSegment> otherAccumulated) {
        accumulated.addAll(otherAccumulated);
        return accumulated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentGeneratorFrameProcessorFactory that = (SegmentGeneratorFrameProcessorFactory)o;
        return Objects.equals(this.dataSchema, that.dataSchema) && Objects.equals(this.columnMappings, that.columnMappings) && Objects.equals(this.tuningConfig, that.tuningConfig);
    }

    public int hashCode() {
        return Objects.hash(this.dataSchema, this.columnMappings, this.tuningConfig);
    }

    @Override
    public ExtraInfoHolder makeExtraInfoHolder(List<SegmentIdWithShardSpec> segmentIdsWithShardSpecs) {
        return new SegmentGeneratorExtraInfoHolder(segmentIdsWithShardSpecs);
    }

    private static AppenderatorConfig makeAppenderatorConfig(final MSQTuningConfig tuningConfig, final File persistDirectory, final WorkerMemoryParameters memoryParameters) {
        return new AppenderatorConfig(){

            public AppendableIndexSpec getAppendableIndexSpec() {
                return TuningConfig.DEFAULT_APPENDABLE_INDEX;
            }

            public int getMaxRowsInMemory() {
                return tuningConfig.getMaxRowsInMemory();
            }

            public long getMaxBytesInMemory() {
                return memoryParameters.getAppenderatorMaxBytesInMemory();
            }

            public PartitionsSpec getPartitionsSpec() {
                return new DynamicPartitionsSpec(Integer.valueOf(Integer.MAX_VALUE), Long.valueOf(Long.MAX_VALUE));
            }

            public IndexSpec getIndexSpec() {
                return tuningConfig.getIndexSpec();
            }

            public IndexSpec getIndexSpecForIntermediatePersists() {
                return new IndexSpec(null, CompressionStrategy.UNCOMPRESSED, CompressionStrategy.NONE, CompressionFactory.LongEncodingStrategy.LONGS, null);
            }

            public boolean isReportParseExceptions() {
                return true;
            }

            public int getMaxPendingPersists() {
                return 0;
            }

            public boolean isSkipBytesInMemoryOverheadCheck() {
                return false;
            }

            public Period getIntermediatePersistPeriod() {
                return new Period(Integer.MAX_VALUE);
            }

            public File getBasePersistDirectory() {
                return persistDirectory;
            }

            public AppenderatorConfig withBasePersistDirectory(File basePersistDirectory) {
                throw new UnsupportedOperationException();
            }

            @Nullable
            public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
                return null;
            }

            public int getMaxColumnsToMerge() {
                return memoryParameters.getAppenderatorMaxColumnsToMerge();
            }
        };
    }

    @JsonTypeName(value="segmentGenerator")
    public static class SegmentGeneratorExtraInfoHolder
    extends ExtraInfoHolder<List<SegmentIdWithShardSpec>> {
        @JsonCreator
        public SegmentGeneratorExtraInfoHolder(@Nullable @JsonProperty(value="info") List<SegmentIdWithShardSpec> extra) {
            super(extra);
        }
    }
}

