/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.msq.exec.ControllerContext;
import org.apache.druid.msq.exec.WorkerManagerClient;
import org.apache.druid.msq.indexing.MSQWorkerTask;
import org.apache.druid.msq.indexing.WorkerCount;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.TaskStartTimeoutFault;
import org.apache.druid.msq.indexing.error.UnknownFault;
import org.apache.druid.msq.indexing.error.WorkerFailedFault;

public class MSQWorkerTaskLauncher {
    private static final Logger log = new Logger(MSQWorkerTaskLauncher.class);
    private static final long HIGH_FREQUENCY_CHECK_MILLIS = 100L;
    private static final long LOW_FREQUENCY_CHECK_MILLIS = 2000L;
    private static final long SWITCH_TO_LOW_FREQUENCY_CHECK_AFTER_MILLIS = 10000L;
    private static final long SHUTDOWN_TIMEOUT_MS = Duration.ofMinutes(1L).toMillis();
    private final String controllerTaskId;
    private final String dataSource;
    private final ControllerContext context;
    private final ExecutorService exec;
    private final long maxTaskStartDelayMillis;
    private final boolean durableStageStorageEnabled;
    @Nullable
    private final Long maxParseExceptions;
    private final SettableFuture<?> stopFuture = SettableFuture.create();
    private final AtomicReference<State> state = new AtomicReference<State>(State.NEW);
    private final AtomicBoolean cancelTasksOnStop = new AtomicBoolean();
    @GuardedBy(value="taskIds")
    private int desiredTaskCount = 0;
    @GuardedBy(value="taskIds")
    private int acknowledgedDesiredTaskCount = 0;
    @GuardedBy(value="taskIds")
    private final List<String> taskIds = new ArrayList<String>();
    @GuardedBy(value="taskIds")
    private final IntSet fullyStartedTasks = new IntOpenHashSet();
    private final Map<String, TaskTracker> taskTrackers = new LinkedHashMap<String, TaskTracker>();
    private final Set<String> canceledWorkerTasks = ConcurrentHashMap.newKeySet();

    public MSQWorkerTaskLauncher(String controllerTaskId, String dataSource, ControllerContext context, boolean durableStageStorageEnabled, @Nullable Long maxParseExceptions, long maxTaskStartDelayMillis) {
        this.controllerTaskId = controllerTaskId;
        this.dataSource = dataSource;
        this.context = context;
        this.exec = Execs.singleThreaded((String)("multi-stage-query-task-launcher[" + StringUtils.encodeForFormat((String)controllerTaskId) + "]-%s"));
        this.durableStageStorageEnabled = durableStageStorageEnabled;
        this.maxParseExceptions = maxParseExceptions;
        this.maxTaskStartDelayMillis = maxTaskStartDelayMillis;
    }

    public ListenableFuture<?> start() {
        if (this.state.compareAndSet(State.NEW, State.STARTED)) {
            this.exec.submit(() -> {
                try {
                    this.mainLoop();
                }
                catch (Throwable e) {
                    log.warn(e, "Error encountered in main loop. Abandoning worker tasks.", new Object[0]);
                }
            });
        }
        return this.stopFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean interrupt) {
        if (this.state.compareAndSet(State.STARTED, State.STOPPED)) {
            if (interrupt) {
                this.cancelTasksOnStop.set(true);
            }
            List<String> list = this.taskIds;
            synchronized (list) {
                this.taskIds.notifyAll();
            }
            this.exec.shutdown();
        } else if (this.state.get() == State.STOPPED) {
            if (interrupt) {
                this.cancelTasksOnStop.set(true);
            }
        } else {
            throw new ISE("Cannot stop(%s) from state [%s]", new Object[]{interrupt, this.state.get()});
        }
        try {
            FutureUtils.getUnchecked(this.stopFuture, (boolean)false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTaskList() {
        List<String> list = this.taskIds;
        synchronized (list) {
            return ImmutableList.copyOf(this.taskIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchTasksIfNeeded(int taskCount) throws InterruptedException {
        List<String> list = this.taskIds;
        synchronized (list) {
            if (taskCount > this.desiredTaskCount) {
                this.desiredTaskCount = taskCount;
                this.taskIds.notifyAll();
            }
            while (true) {
                if (this.taskIds.size() >= taskCount) {
                    if (IntStream.range(0, taskCount).allMatch(arg_0 -> ((IntSet)this.fullyStartedTasks).contains(arg_0))) break;
                }
                if (this.stopFuture.isDone() || this.stopFuture.isCancelled()) {
                    FutureUtils.getUnchecked(this.stopFuture, (boolean)false);
                    throw new ISE("Stopped", new Object[0]);
                }
                this.taskIds.wait();
            }
        }
    }

    public boolean isTaskCanceledByController(String taskId) {
        return this.canceledWorkerTasks.contains(taskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mainLoop() {
        block14: {
            try {
                Throwable caught = null;
                while (this.state.get() == State.STARTED) {
                    long loopStartTime = System.currentTimeMillis();
                    try {
                        this.runNewTasks();
                        this.updateTaskTrackersAndTaskIds();
                        this.checkForErroneousTasks();
                    }
                    catch (Throwable e) {
                        this.state.set(State.STOPPED);
                        this.cancelTasksOnStop.set(true);
                        caught = e;
                        break;
                    }
                    this.sleep(this.computeSleepTime(System.currentTimeMillis() - loopStartTime), false);
                }
                assert (this.state.get() == State.STOPPED);
                long stopStartTime = System.currentTimeMillis();
                while (this.taskTrackers.values().stream().anyMatch(tracker -> !tracker.isComplete())) {
                    long loopStartTime = System.currentTimeMillis();
                    if (this.cancelTasksOnStop.get()) {
                        this.shutDownTasks();
                    }
                    this.updateTaskTrackersAndTaskIds();
                    long now = System.currentTimeMillis();
                    if (now > stopStartTime + SHUTDOWN_TIMEOUT_MS) {
                        if (caught != null) {
                            throw caught;
                        }
                        throw new ISE("Task shutdown timed out (limit = %,dms)", new Object[]{SHUTDOWN_TIMEOUT_MS});
                    }
                    this.sleep(this.computeSleepTime(now - loopStartTime), true);
                }
                if (caught != null) {
                    throw caught;
                }
                this.stopFuture.set(null);
            }
            catch (Throwable e) {
                if (this.stopFuture.isDone()) break block14;
                this.stopFuture.setException(e);
            }
        }
        List<String> list = this.taskIds;
        synchronized (list) {
            this.taskIds.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runNewTasks() {
        int taskCount;
        HashMap<String, Object> taskContext = new HashMap<String, Object>();
        if (this.durableStageStorageEnabled) {
            taskContext.put("durableShuffleStorage", true);
        }
        if (this.maxParseExceptions != null) {
            taskContext.put("maxParseExceptions", this.maxParseExceptions);
        }
        List<String> list = this.taskIds;
        synchronized (list) {
            int firstTask = this.taskIds.size();
            taskCount = this.desiredTaskCount;
            this.acknowledgedDesiredTaskCount = this.desiredTaskCount;
        }
        for (int i = firstTask; i < taskCount; ++i) {
            MSQWorkerTask task = new MSQWorkerTask(this.controllerTaskId, this.dataSource, i, taskContext);
            this.taskTrackers.put(task.getId(), new TaskTracker(i));
            this.context.workerManager().run(task.getId(), task);
            List<String> list2 = this.taskIds;
            synchronized (list2) {
                this.taskIds.add(task.getId());
                this.taskIds.notifyAll();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerCount getWorkerTaskCount() {
        List<String> list = this.taskIds;
        synchronized (list) {
            int runningTasks = this.fullyStartedTasks.size();
            int pendingTasks = this.desiredTaskCount - runningTasks;
            return new WorkerCount(runningTasks, pendingTasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTaskTrackersAndTaskIds() {
        HashSet<String> taskStatusesNeeded = new HashSet<String>();
        for (Map.Entry<String, TaskTracker> taskEntry : this.taskTrackers.entrySet()) {
            if (taskEntry.getValue().isComplete()) continue;
            taskStatusesNeeded.add(taskEntry.getKey());
        }
        if (!taskStatusesNeeded.isEmpty()) {
            WorkerManagerClient workerManager = this.context.workerManager();
            Map<String, TaskStatus> statuses = workerManager.statuses(taskStatusesNeeded);
            for (Map.Entry<String, TaskStatus> statusEntry : statuses.entrySet()) {
                String taskId = statusEntry.getKey();
                TaskTracker tracker = this.taskTrackers.get(taskId);
                tracker.status = statusEntry.getValue();
                if (!tracker.status.getStatusCode().isComplete() && tracker.unknownLocation()) {
                    tracker.initialLocation = workerManager.location(taskId);
                }
                if (tracker.status.getStatusCode() != TaskState.RUNNING || tracker.unknownLocation()) continue;
                List<String> list = this.taskIds;
                synchronized (list) {
                    this.fullyStartedTasks.add(tracker.workerNumber);
                    this.taskIds.notifyAll();
                }
            }
        }
    }

    private void checkForErroneousTasks() {
        int numTasks = this.taskTrackers.size();
        for (Map.Entry<String, TaskTracker> taskEntry : this.taskTrackers.entrySet()) {
            String taskId = taskEntry.getKey();
            TaskTracker tracker = taskEntry.getValue();
            if (tracker.status == null) {
                throw new MSQException(UnknownFault.forMessage(StringUtils.format((String)"Task [%s] status missing", (Object[])new Object[]{taskId})));
            }
            if (tracker.didRunTimeOut(this.maxTaskStartDelayMillis) && !this.canceledWorkerTasks.contains(taskId)) {
                throw new MSQException(new TaskStartTimeoutFault(numTasks + 1));
            }
            if (!tracker.didFail() || this.canceledWorkerTasks.contains(taskId)) continue;
            throw new MSQException(new WorkerFailedFault(taskId, tracker.status.getErrorMsg()));
        }
    }

    private void shutDownTasks() {
        for (Map.Entry<String, TaskTracker> taskEntry : this.taskTrackers.entrySet()) {
            String taskId = taskEntry.getKey();
            TaskTracker tracker = taskEntry.getValue();
            if (this.canceledWorkerTasks.contains(taskId) || tracker.status != null && tracker.status.getStatusCode().isComplete()) continue;
            this.canceledWorkerTasks.add(taskId);
            this.context.workerManager().cancel(taskId);
        }
    }

    private long computeSleepTime(long loopDurationMs) {
        OptionalLong maxTaskStartTime = this.taskTrackers.values().stream().mapToLong(tracker -> ((TaskTracker)tracker).startTimeMs).max();
        if (maxTaskStartTime.isPresent() && System.currentTimeMillis() - maxTaskStartTime.getAsLong() < 10000L) {
            return 100L - loopDurationMs;
        }
        return 2000L - loopDurationMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sleep(long sleepMillis, boolean shuttingDown) throws InterruptedException {
        if (sleepMillis > 0L) {
            if (shuttingDown) {
                Thread.sleep(sleepMillis);
            } else {
                List<String> list = this.taskIds;
                synchronized (list) {
                    if (this.acknowledgedDesiredTaskCount == this.desiredTaskCount) {
                        this.taskIds.wait(sleepMillis);
                    }
                }
            }
        } else if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    private static class TaskTracker {
        private final int workerNumber;
        private final long startTimeMs = System.currentTimeMillis();
        private TaskStatus status;
        private TaskLocation initialLocation;

        public TaskTracker(int workerNumber) {
            this.workerNumber = workerNumber;
        }

        public boolean unknownLocation() {
            return this.initialLocation == null || TaskLocation.unknown().equals((Object)this.initialLocation);
        }

        public boolean isComplete() {
            return this.status != null && this.status.getStatusCode().isComplete();
        }

        public boolean didFail() {
            return this.status != null && this.status.getStatusCode().isFailure();
        }

        public boolean didRunTimeOut(long maxTaskStartDelayMillis) {
            return (this.status == null || this.status.getStatusCode() == TaskState.RUNNING) && this.unknownLocation() && System.currentTimeMillis() - this.startTimeMs > maxTaskStartDelayMillis;
        }
    }

    private static enum State {
        NEW,
        STARTED,
        STOPPED;

    }
}

