/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Injector;
import java.util.Map;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.msq.exec.MSQTasks;
import org.apache.druid.msq.exec.Worker;
import org.apache.druid.msq.exec.WorkerImpl;
import org.apache.druid.msq.indexing.IndexerWorkerContext;

@JsonTypeName(value="query_worker")
public class MSQWorkerTask
extends AbstractTask {
    public static final String TYPE = "query_worker";
    private final String controllerTaskId;
    private final int workerNumber;
    @JacksonInject
    private Injector injector;
    private volatile Worker worker;

    @JsonCreator
    @VisibleForTesting
    public MSQWorkerTask(@JsonProperty(value="controllerTaskId") String controllerTaskId, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="workerNumber") int workerNumber, @JsonProperty(value="context") Map<String, Object> context) {
        super(MSQTasks.workerTaskId(controllerTaskId, workerNumber), controllerTaskId, null, dataSource, context);
        this.controllerTaskId = controllerTaskId;
        this.workerNumber = workerNumber;
    }

    @JsonProperty
    public String getControllerTaskId() {
        return this.controllerTaskId;
    }

    @JsonProperty
    public int getWorkerNumber() {
        return this.workerNumber;
    }

    public String getType() {
        return TYPE;
    }

    public boolean isReady(TaskActionClient taskActionClient) {
        return true;
    }

    public TaskStatus runTask(TaskToolbox toolbox) throws Exception {
        IndexerWorkerContext context = IndexerWorkerContext.createProductionInstance(toolbox, this.injector);
        this.worker = new WorkerImpl(this, context);
        return this.worker.run();
    }

    public void stopGracefully(TaskConfig taskConfig) {
        if (this.worker != null) {
            this.worker.stopGracefully();
        }
    }

    public int getPriority() {
        return (Integer)this.getContextValue("priority", 50);
    }
}

