/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.segment.IndexSpec;

public class MSQTuningConfig {
    private static final int DEFAULT_MAX_ROWS_IN_MEMORY = 100000;
    private static final int DEFAULT_MAX_NUM_TASKS = 1;
    @Nullable
    private final Integer maxNumWorkers;
    @Nullable
    private final Integer maxRowsInMemory;
    @Nullable
    private final Integer rowsPerSegment;
    @Nullable
    private final IndexSpec indexSpec;

    public MSQTuningConfig(@JsonProperty(value="maxNumWorkers") @Nullable Integer maxNumWorkers, @JsonProperty(value="maxRowsInMemory") @Nullable Integer maxRowsInMemory, @JsonProperty(value="rowsPerSegment") @Nullable Integer rowsPerSegment, @JsonProperty(value="indexSpec") @Nullable IndexSpec indexSpec) {
        this.maxNumWorkers = maxNumWorkers;
        this.maxRowsInMemory = maxRowsInMemory;
        this.rowsPerSegment = rowsPerSegment;
        this.indexSpec = indexSpec;
    }

    public static MSQTuningConfig defaultConfig() {
        return new MSQTuningConfig(null, null, null, null);
    }

    @JsonProperty(value="maxNumWorkers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    Integer getMaxNumWorkersForSerialization() {
        return this.maxNumWorkers;
    }

    @JsonProperty(value="maxRowsInMemory")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    Integer getMaxRowsInMemoryForSerialization() {
        return this.maxRowsInMemory;
    }

    @JsonProperty(value="rowsPerSegment")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    Integer getRowsPerSegmentForSerialization() {
        return this.rowsPerSegment;
    }

    @JsonProperty(value="indexSpec")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    IndexSpec getIndexSpecForSerialization() {
        return this.indexSpec;
    }

    public int getMaxNumWorkers() {
        return this.maxNumWorkers != null ? this.maxNumWorkers : 1;
    }

    public int getMaxRowsInMemory() {
        return this.maxRowsInMemory != null ? this.maxRowsInMemory : 100000;
    }

    public int getRowsPerSegment() {
        return this.rowsPerSegment != null ? this.rowsPerSegment : 5000000;
    }

    public IndexSpec getIndexSpec() {
        return this.indexSpec != null ? this.indexSpec : new IndexSpec();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MSQTuningConfig that = (MSQTuningConfig)o;
        return Objects.equals(this.maxNumWorkers, that.maxNumWorkers) && Objects.equals(this.maxRowsInMemory, that.maxRowsInMemory) && Objects.equals(this.rowsPerSegment, that.rowsPerSegment) && Objects.equals(this.indexSpec, that.indexSpec);
    }

    public int hashCode() {
        return Objects.hash(this.maxNumWorkers, this.maxRowsInMemory, this.rowsPerSegment, this.indexSpec);
    }

    public String toString() {
        return "MSQTuningConfig{maxNumWorkers=" + this.maxNumWorkers + ", maxRowsInMemory=" + this.maxRowsInMemory + ", rowsPerSegment=" + this.rowsPerSegment + ", indexSpec=" + this.indexSpec + '}';
    }
}

