/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TimeChunkLockTryAcquireAction;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.msq.exec.Controller;
import org.apache.druid.msq.exec.ControllerImpl;
import org.apache.druid.msq.exec.MSQTasks;
import org.apache.druid.msq.indexing.DataSourceMSQDestination;
import org.apache.druid.msq.indexing.IndexerControllerContext;
import org.apache.druid.msq.indexing.MSQDestination;
import org.apache.druid.msq.indexing.MSQSpec;
import org.apache.druid.msq.util.MultiStageQueryContext;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.joda.time.Interval;

@JsonTypeName(value="query_controller")
public class MSQControllerTask
extends AbstractTask {
    public static final String TYPE = "query_controller";
    public static final String DUMMY_DATASOURCE_FOR_SELECT = "__query_select";
    private final MSQSpec querySpec;
    @Nullable
    private final String sqlQuery;
    @Nullable
    private final Map<String, Object> sqlQueryContext;
    @Nullable
    private final List<String> sqlTypeNames;
    @Nullable
    private final ExecutorService remoteFetchExecutorService;
    @JacksonInject
    private Injector injector;
    private volatile Controller controller;

    @JsonCreator
    public MSQControllerTask(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="spec") MSQSpec querySpec, @JsonProperty(value="sqlQuery") @Nullable String sqlQuery, @JsonProperty(value="sqlQueryContext") @Nullable Map<String, Object> sqlQueryContext, @JsonProperty(value="sqlTypeNames") @Nullable List<String> sqlTypeNames, @JsonProperty(value="context") @Nullable Map<String, Object> context) {
        super(id != null ? id : MSQTasks.controllerTaskId(null), id, null, MSQControllerTask.getDataSourceForTaskMetadata(querySpec), context);
        this.querySpec = querySpec;
        this.sqlQuery = sqlQuery;
        this.sqlQueryContext = sqlQueryContext;
        this.sqlTypeNames = sqlTypeNames;
        this.remoteFetchExecutorService = MultiStageQueryContext.isDurableStorageEnabled(querySpec.getQuery().context()) ? Executors.newCachedThreadPool(Execs.makeThreadFactory((String)(this.getId() + "-remote-fetcher-%d"))) : null;
        this.addToContext("forceTimeChunkLock", true);
    }

    public String getType() {
        return TYPE;
    }

    @JsonProperty(value="spec")
    public MSQSpec getQuerySpec() {
        return this.querySpec;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getSqlQuery() {
        return this.sqlQuery;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Map<String, Object> getSqlQueryContext() {
        return this.sqlQueryContext;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<String> getSqlTypeNames() {
        return this.sqlTypeNames;
    }

    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        if (MSQControllerTask.isIngestion(this.querySpec) && ((DataSourceMSQDestination)this.querySpec.getDestination()).isReplaceTimeChunks()) {
            List<Interval> intervals = ((DataSourceMSQDestination)this.querySpec.getDestination()).getReplaceTimeChunks();
            for (Interval interval : intervals) {
                TaskLock taskLock = (TaskLock)taskActionClient.submit((TaskAction)new TimeChunkLockTryAcquireAction(TaskLockType.EXCLUSIVE, interval));
                if (taskLock == null) {
                    return false;
                }
                if (!taskLock.isRevoked()) continue;
                throw new ISE(StringUtils.format((String)"Lock for interval [%s] was revoked", (Object[])new Object[]{interval}), new Object[0]);
            }
        }
        return true;
    }

    public TaskStatus runTask(TaskToolbox toolbox) throws Exception {
        ServiceClientFactory clientFactory = (ServiceClientFactory)this.injector.getInstance(Key.get(ServiceClientFactory.class, EscalatedGlobal.class));
        OverlordClient overlordClient = ((OverlordClient)this.injector.getInstance(OverlordClient.class)).withRetryPolicy((ServiceRetryPolicy)StandardRetryPolicy.unlimited());
        IndexerControllerContext context = new IndexerControllerContext(toolbox, this.injector, clientFactory, overlordClient);
        this.controller = new ControllerImpl(this, context);
        return this.controller.run();
    }

    public void stopGracefully(TaskConfig taskConfig) {
        if (this.controller != null) {
            this.controller.stopGracefully();
        }
        if (this.remoteFetchExecutorService != null) {
            this.remoteFetchExecutorService.shutdownNow();
        }
    }

    public int getPriority() {
        return (Integer)this.getContextValue("priority", 50);
    }

    private static String getDataSourceForTaskMetadata(MSQSpec querySpec) {
        MSQDestination destination = querySpec.getDestination();
        if (destination instanceof DataSourceMSQDestination) {
            return ((DataSourceMSQDestination)destination).getDataSource();
        }
        return DUMMY_DATASOURCE_FOR_SELECT;
    }

    public static boolean isIngestion(MSQSpec querySpec) {
        return querySpec.getDestination() instanceof DataSourceMSQDestination;
    }
}

