/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntBidirectionalIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.druid.frame.FrameType;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.channel.BlockingQueueFrameChannel;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.processor.FrameChannelMerger;
import org.apache.druid.frame.processor.FrameChannelMuxer;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessorExecutor;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.msq.indexing.InputChannelFactory;
import org.apache.druid.msq.input.stage.InputChannels;
import org.apache.druid.msq.input.stage.ReadablePartition;
import org.apache.druid.msq.input.stage.ReadablePartitions;
import org.apache.druid.msq.kernel.QueryDefinition;
import org.apache.druid.msq.kernel.StageDefinition;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.kernel.StagePartition;
import org.apache.druid.segment.column.RowSignature;

public class InputChannelsImpl
implements InputChannels {
    private final QueryDefinition queryDefinition;
    private final InputChannelFactory channelFactory;
    private final Supplier<MemoryAllocator> allocatorMaker;
    private final FrameProcessorExecutor exec;
    private final String cancellationId;
    private final Map<StagePartition, ReadablePartition> readablePartitionMap;

    public InputChannelsImpl(QueryDefinition queryDefinition, ReadablePartitions readablePartitions, InputChannelFactory channelFactory, Supplier<MemoryAllocator> allocatorMaker, FrameProcessorExecutor exec, String cancellationId) {
        this.queryDefinition = queryDefinition;
        this.readablePartitionMap = new HashMap<StagePartition, ReadablePartition>();
        this.channelFactory = channelFactory;
        this.allocatorMaker = allocatorMaker;
        this.exec = exec;
        this.cancellationId = cancellationId;
        for (ReadablePartition readablePartition : readablePartitions) {
            this.readablePartitionMap.put(new StagePartition(new StageId(queryDefinition.getQueryId(), readablePartition.getStageNumber()), readablePartition.getPartitionNumber()), readablePartition);
        }
    }

    @Override
    public ReadableFrameChannel openChannel(StagePartition stagePartition) throws IOException {
        boolean isSorted;
        StageDefinition stageDef = this.queryDefinition.getStageDefinition(stagePartition.getStageId());
        ReadablePartition readablePartition = this.readablePartitionMap.get(stagePartition);
        ClusterBy inputClusterBy = stageDef.getClusterBy();
        boolean bl = isSorted = inputClusterBy.getBucketByCount() != inputClusterBy.getColumns().size();
        if (isSorted) {
            return this.openSorted(stageDef, readablePartition);
        }
        return this.openUnsorted(stageDef, readablePartition);
    }

    @Override
    public FrameReader frameReader(int stageNumber) {
        return this.queryDefinition.getStageDefinition(stageNumber).getFrameReader();
    }

    private ReadableFrameChannel openSorted(StageDefinition stageDefinition, ReadablePartition readablePartition) throws IOException {
        BlockingQueueFrameChannel queueChannel = BlockingQueueFrameChannel.minimal();
        List<ReadableFrameChannel> channels = this.openChannels(stageDefinition.getId(), readablePartition);
        if (channels.size() == 1) {
            return (ReadableFrameChannel)Iterables.getOnlyElement(channels);
        }
        FrameChannelMerger merger = new FrameChannelMerger(channels, stageDefinition.getFrameReader(), queueChannel.writable(), FrameWriters.makeFrameWriterFactory((FrameType)FrameType.ROW_BASED, (MemoryAllocator)this.allocatorMaker.get(), (RowSignature)stageDefinition.getFrameReader().signature(), Collections.emptyList()), stageDefinition.getClusterBy(), null, -1L);
        this.exec.runFully((FrameProcessor)merger, this.cancellationId);
        return queueChannel.readable();
    }

    private ReadableFrameChannel openUnsorted(StageDefinition stageDefinition, ReadablePartition readablePartition) throws IOException {
        List<ReadableFrameChannel> channels = this.openChannels(stageDefinition.getId(), readablePartition);
        if (channels.size() == 1) {
            return (ReadableFrameChannel)Iterables.getOnlyElement(channels);
        }
        BlockingQueueFrameChannel queueChannel = BlockingQueueFrameChannel.minimal();
        FrameChannelMuxer muxer = new FrameChannelMuxer(channels, queueChannel.writable());
        this.exec.runFully((FrameProcessor)muxer, this.cancellationId);
        return queueChannel.readable();
    }

    private List<ReadableFrameChannel> openChannels(StageId stageId, ReadablePartition readablePartition) throws IOException {
        ArrayList<ReadableFrameChannel> channels = new ArrayList<ReadableFrameChannel>();
        try {
            IntBidirectionalIterator intBidirectionalIterator = readablePartition.getWorkerNumbers().iterator();
            while (intBidirectionalIterator.hasNext()) {
                int workerNumber = (Integer)intBidirectionalIterator.next();
                channels.add(this.channelFactory.openChannel(stageId, workerNumber, readablePartition.getPartitionNumber()));
            }
            return channels;
        }
        catch (Exception e) {
            for (ReadableFrameChannel channel : channels) {
                try {
                    channel.close();
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
            }
            throw e;
        }
    }
}

